/*!\file Exp2Kmlx
 * \brief exp to kml conversion routines.
 */

#include "./Exp2Kmlx.h"
#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../modules.h"

int Exp2Kmlx(char* filexp,char* filkml,
			 int sgn,
			 bool holes){

	double  cm,sp;

	Xy2lldef(&cm,&sp,sgn);

	return(Exp2Kmlx(filexp,filkml,
					sgn,cm,sp,
					holes));
}

int Exp2Kmlx(char* filexp,char* filkml,
			 int sgn,double cm,double sp,
			 bool holes){

	int     i,j,iret=0;
	int     nprof;
	int     *pnvert=NULL;
	double  **pprofx=NULL,**pprofy=NULL;
	bool    *closed=NULL;
	double  *lat=NULL,*lon=NULL;

	char    indent[81]="";
	KML_File*          kfile =NULL;
	KML_Document*      kdoc  =NULL;
	KML_Folder*        kfold =NULL;
	KML_Placemark*     kplace=NULL;
	KML_Polygon*       kpoly =NULL;
	KML_LinearRing*    kring =NULL;
	KML_LineString*    kline =NULL;

	FILE*   fid=NULL;

	clock_t clock0,clock1;
	time_t  time0, time1;

	clock0=clock();
	time0 =time(NULL);
	_printf_(true,"\nExp2Kmlx Module -- %s",ctime(&time0));

/*  read exp file  */

	if (!DomainOutlineRead(&nprof,&pnvert,&pprofx,&pprofy,&closed,filexp,false))
		_error_("Error reading exp file.");

/*  construct kml file  */

	kfile =new KML_File();
	kfile->AddAttrib("xmlns","http://www.opengis.net/kml/2.2");

/*  construct kml document  */

	kdoc  =new KML_Document();
	sprintf(kdoc->name      ,"Exp2Kmlx Module -- %s",ctime(&time0));
	kdoc->open      =1;

/*  construct kml folder for polygons  */

	kfold =new KML_Folder();
	sprintf(kfold->name      ,"Profiles translated from file \"%s\".",filexp);
	kfold->open      =1;

/*  polygon with multiple holes  */

	if (holes && nprof && !closed[0]) {
		_printf_(true,"Warning -- Outer profile is not closed, so \"holes\" option will be ignored.\n");
		holes=false;
	}

	if (holes) {
		i=0;
		kplace=new KML_Placemark();
		sprintf(kplace->name      ,"Polygon with Holes");
		kplace->visibility=true;

		kpoly =new KML_Polygon();
		kring =new KML_LinearRing();

		lat=(double *) xmalloc(pnvert[i]*sizeof(double));
		lon=(double *) xmalloc(pnvert[i]*sizeof(double));
		Xy2llx(lat,lon,pprofx[i],pprofy[i],pnvert[i],sgn,cm,sp);

		kring->ncoord    =pnvert[i];
		kring->coords    =(double (*)[3]) xmalloc(pnvert[i]*3*sizeof(double));
		for (j=0; j<pnvert[i]; j++) {
			kring->coords[j][0]=lon[j];
			kring->coords[j][1]=lat[j];
			kring->coords[j][2]=0.;
		}
		xfree((void**)&lon);
		xfree((void**)&lat);

		(kpoly ->outer     )->AddObject((Object*)kring);
		kring =NULL;

		for (i=1; i<nprof; i++) {
			if (!closed[i]) {
				_printf_(true,"Warning -- Inner profile %d is not closed with \"holes\" specified, so it will be ignored.\n",i+1);
				continue;
			}

			kring =new KML_LinearRing();

			lat=(double *) xmalloc(pnvert[i]*sizeof(double));
			lon=(double *) xmalloc(pnvert[i]*sizeof(double));
			Xy2llx(lat,lon,pprofx[i],pprofy[i],pnvert[i],sgn,cm,sp);
			kring->ncoord    =pnvert[i];
			kring->coords    =(double (*)[3]) xmalloc(pnvert[i]*3*sizeof(double));
			for (j=0; j<pnvert[i]; j++) {
				kring->coords[j][0]=lon[j];
				kring->coords[j][1]=lat[j];
				kring->coords[j][2]=0.;
			}
			xfree((void**)&lon);
			xfree((void**)&lat);

			(kpoly ->inner     )->AddObject((Object*)kring);
			kring =NULL;
		}

		(kplace->geometry  )->AddObject((Object*)kpoly);
		kpoly =NULL;
		(kfold ->feature   )->AddObject((Object*)kplace);
		kplace=NULL;
	}

/*  multiple polygons or linestrings  */

	else {
		for (i=0; i<nprof; i++) {
			kplace=new KML_Placemark();

			if (closed[i]) {
				sprintf(kplace->name      ,"Polygon %d",i+1);
				kplace->visibility=true;

				kpoly =new KML_Polygon();
				kring =new KML_LinearRing();

				lat=(double *) xmalloc(pnvert[i]*sizeof(double));
				lon=(double *) xmalloc(pnvert[i]*sizeof(double));
				Xy2llx(lat,lon,pprofx[i],pprofy[i],pnvert[i],sgn,cm,sp);

				kring->ncoord    =pnvert[i];
				kring->coords    =(double (*)[3]) xmalloc(pnvert[i]*3*sizeof(double));
				for (j=0; j<pnvert[i]; j++) {
					kring->coords[j][0]=lon[j];
					kring->coords[j][1]=lat[j];
					kring->coords[j][2]=0.;
				}
				xfree((void**)&lon);
				xfree((void**)&lat);

				(kpoly ->outer     )->AddObject((Object*)kring);
				kring =NULL;

				(kplace->geometry  )->AddObject((Object*)kpoly);
				kpoly =NULL;
			}

			else {
				sprintf(kplace->name      ,"LineString %d",i+1);
				kplace->visibility=true;

				kline =new KML_LineString();

				lat=(double *) xmalloc(pnvert[i]*sizeof(double));
				lon=(double *) xmalloc(pnvert[i]*sizeof(double));
				Xy2llx(lat,lon,pprofx[i],pprofy[i],pnvert[i],sgn,cm,sp);

				kline->ncoord    =pnvert[i];
				kline->coords    =(double (*)[3]) xmalloc(pnvert[i]*3*sizeof(double));
				for (j=0; j<pnvert[i]; j++) {
					kline->coords[j][0]=lon[j];
					kline->coords[j][1]=lat[j];
					kline->coords[j][2]=0.;
				}
				xfree((void**)&lon);
				xfree((void**)&lat);

				(kplace->geometry  )->AddObject((Object*)kline);
				kline =NULL;
			}

			(kfold ->feature   )->AddObject((Object*)kplace);
			kplace=NULL;
		}
	}

/*  assemble the rest of the kml hierarchy  */

	(kdoc ->feature   )->AddObject((Object*)kfold);
	kfold=NULL;
	(kfile->kmlobj    )->AddObject((Object*)kdoc);
	kdoc =NULL;

/*  write kml file  */

	_printf_(true,"Writing kml document to file.\n");
	fid=fopen(filkml,"w");
	fprintf(fid,"<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
	kfile->Write(fid,indent);
	fclose(fid);

	delete kfile;
	for (i=nprof-1; i>=0; i--) {
		xfree((void**)&(pprofy[i]));
		xfree((void**)&(pprofx[i]));
	}
	xfree((void**)&pnvert);

	clock1=clock();
	time1 =time(NULL);
	_printf_(true,"Exp2Kmlx Module -- %f CPU seconds; %f elapsed seconds.\n\n",
			 ((double)(clock1-clock0))/CLOCKS_PER_SEC,difftime(time1,time0));

	return(iret);
}

