md=mesh(model,'../Exp/Pig.exp',30000);
md=geography(md,'../Exp/PigShelves.exp','../Exp/PigIslands.exp');
md=parameterize(md,'../Par/Pig.par');
md=extrude(md,2,1);
md=setelementstype(md,'pattyn','all');
md.cluster=none;
md=solve(md,TransientSolutionEnum);

%Fields and tolerances to track changes
field_names     ={'Vx1','Vy1','Vz1','Vel1','Pressure1','Bed1','Surface1','Thickness1','Temperature1','BasalMeltingRate1', ...
				      'Vx2','Vy2','Vz2','Vel2','Pressure2','Bed2','Surface2','Thickness2','Temperature2','BasalMeltingRate2'};
field_tolerances={1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,...
						1e-12,1e-12,1e-12,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13};
field_values={...
	PatchToVec(md.results.TransientSolution(1).Vx),...
	PatchToVec(md.results.TransientSolution(1).Vy),...
	PatchToVec(md.results.TransientSolution(1).Vz),...
	PatchToVec(md.results.TransientSolution(1).Vel),...
	PatchToVec(md.results.TransientSolution(1).Pressure),...
	PatchToVec(md.results.TransientSolution(1).Bed),...
	PatchToVec(md.results.TransientSolution(1).Surface),...
	PatchToVec(md.results.TransientSolution(1).Thickness),...
	PatchToVec(md.results.TransientSolution(1).Temperature),...
	PatchToVec(md.results.TransientSolution(1).BasalMeltingRate),...
	PatchToVec(md.results.TransientSolution(2).Vx),...
	PatchToVec(md.results.TransientSolution(2).Vy),...
	PatchToVec(md.results.TransientSolution(2).Vz),...
	PatchToVec(md.results.TransientSolution(2).Vel),...
	PatchToVec(md.results.TransientSolution(2).Pressure),...
	PatchToVec(md.results.TransientSolution(2).Bed),...
	PatchToVec(md.results.TransientSolution(2).Surface),...
	PatchToVec(md.results.TransientSolution(2).Thickness),...
	PatchToVec(md.results.TransientSolution(2).Temperature),...
	PatchToVec(md.results.TransientSolution(2).BasalMeltingRate),...
	};
