md=mesh(model,'../Exp/Square.exp',200000);
md=geography(md,'','');
md=parameterize(md,'../Par/SquareSheetConstrained.par');
md=setelementstype(md,'macayeal','all');

%control parameters
md.control_analysis=1;
md.control_type=DragCoefficientEnum();
md.cm_min=1*ones(md.numberofnodes,1);
md.cm_max=200*ones(md.numberofnodes,1);
md.nsteps=2;
md.cm_responses=[SurfaceLogVelMisfitEnum()*ones(md.nsteps,1)  DragCoefficientAbsGradientEnum*ones(md.nsteps,1)];
md.weights=ones(md.numberofnodes,2); md.weights(:,2)=2*10^-7;
md.optscal=3*ones(md.nsteps,1);
md.maxiter=2*ones(md.nsteps,1);
md.cm_jump=0.3*ones(md.nsteps,1);
md.vx_obs=md.vx; md.vy_obs=md.vy;

md.cluster=generic('name',oshostname(),'np',3);
md=solve(md,DiagnosticSolutionEnum);

%Fields and tolerances to track changes
field_names     ={'Gradient' 'Misfits' 'DragCoefficient' 'Pressure' 'Vel' 'Vx' 'Vy'};
field_tolerances={1e-12,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13};
field_values={...
	PatchToVec(md.results.DiagnosticSolution.Gradient1),...
	md.results.DiagnosticSolution.J,...
	PatchToVec(md.results.DiagnosticSolution.DragCoefficient),...
	PatchToVec(md.results.DiagnosticSolution.Pressure),...
	PatchToVec(md.results.DiagnosticSolution.Vel),...
	PatchToVec(md.results.DiagnosticSolution.Vx),...
	PatchToVec(md.results.DiagnosticSolution.Vy)
};
