function BuildQueueingScriptGeneric(md,executionpath,codepath)
%BUILDQUEUEINGSCRIPTGENERIC - ...
%
%   Usage:
%      BuildQueueingScriptGeneric(md,executionpath,codepath)

%Open queuing script file 
scriptname=[md.name '.queue'];

fid=fopen(scriptname,'w');
if fid==-1,
	error(['BuildQueueingScriptGenericerror message: could not open ' scriptname ' file for ascii writing']);
end

fprintf(fid,'#!/bin/sh\n');
fprintf(fid,'rm -rf %s/%s.lock\n',executionpath,md.name);
fprintf(fid,'mpirun -np %i ',md.np);

if strcmpi(md.analysis_type,'diagnostic'),
	fprintf(fid,'%s/diagnostic.exe',codepath);
elseif strcmpi(md.analysis_type,'control'),
	fprintf(fid,'%s/control.exe',codepath);
elseif strcmpi(md.analysis_type,'thermal'),
	fprintf(fid,'%s/thermal.exe',codepath);
elseif strcmpi(md.analysis_type,'prognostic'),
	fprintf(fid,'%s/prognostic.exe',codepath);
elseif strcmpi(md.analysis_type,'transient'),
	fprintf(fid,'%s/transient.exe',codepath);
else
	error('BuildQueueingScriptGeneric error message: unsupported solution type!');
end

fprintf(fid,' %s %s.bin %s.outbin %s.lock %s.qmu.in %s.qmu.out %s.qmu.err 2> %s.errlog >%s.outlog & ',executionpath,md.name,md.name,md.name,md.name,md.name,md.name,md.name,md.name);
fclose(fid);
