function vec=PatchToVec(Patch);
%PATCHTOVEC - converts a patch to a vector by averaging over each vertex
%
%   Usage:
%      vec=PatchToVec(Patch)

%if the patch is P0, we need to transform the vector a little bit first
switch(Patch.interpolation(1)),
	case P0Enum,
		vec(Patch.element)=Patch.value;
	case P1Enum,
		connectivity=sparse(Patch.index(:),1,1);
		value       =sparse(Patch.index(:),1,Patch.value(:));
		vec=full(value./connectivity);
	otherwise,
		error('interpolation not supported yet');
	end
