function vec=PatchToVec(Patch);
%PATCHTOVEC - converts a patch to a vector by averaging over each vertex
%
%   Usage:
%      vec=PatchToVec(Patch)

%if the patch is P0, we need to transform the vector a little bit first
if size(Patch.value,2)==1,
	vec=Patch.value(Patch.element);
else
	connectivity=sparse(Patch.index(:),1,1);
	value       =sparse(Patch.index(:),1,Patch.value(:));
	vec=full(value./connectivity);
end
