/*! \file Tria.h 
 *  \brief: header file for tria object
 */

#ifndef _TRIA_H_
#define _TRIA_H_

/*Headers:*/
/*{{{1*/
#include "./Element.h"
#include "./TriaHook.h"
#include "./TriaRef.h"
class Parameters;
class Inputs;
class IoModel;
class Node;
class Matice;
class Matpar;
class ElementMatrix;
class ElementVector;

#include "../../include/include.h"
#include "../../shared/Exceptions/exceptions.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
/*}}}*/

class Tria: public Element,public TriaHook,public TriaRef{

	public:

		int  id;
		int  sid;

		Node   **nodes;    // 3 nodes
		Matice  *matice;   // 1 material ice
		Matpar  *matpar;   // 1 material parameter
		int      horizontalneighborsids[3];

		Parameters *parameters;   //pointer to solution parameters
		Inputs     *inputs;
		Results    *results;

		/*Tria constructors, destructors {{{1*/
		Tria();
		Tria(int tria_id,int tria_sid,int i, IoModel* iomodel,int nummodels);
		~Tria();
		/*}}}*/
		/*Object virtual functions definitions:{{{1 */
		void  Echo();
		void  DeepEcho();
		int   Id(); 
		int   MyRank();
		void  Marshall(char** pmarshalled_dataset);
		int   MarshallSize();
		void  Demarshall(char** pmarshalled_dataset);
		int   Enum();
		Object* copy();
		/*}}}*/
		/*Update virtual functions resolution: {{{1*/
		void  InputUpdateFromSolution(double* solutiong);
		void  InputUpdateFromVector(double* vector, int name, int type);
		void  InputUpdateFromVector(int* vector, int name, int type);
		void  InputUpdateFromVector(bool* vector, int name, int type);
		void  InputUpdateFromVectorDakota(double* vector, int name, int type);
		void  InputUpdateFromVectorDakota(int* vector, int name, int type);
		void  InputUpdateFromVectorDakota(bool* vector, int name, int type);
		void  InputUpdateFromConstant(double constant, int name);
		void  InputUpdateFromConstant(int constant, int name);
		void  InputUpdateFromConstant(bool constant, int name);
		void  InputUpdateFromIoModel(int index, IoModel* iomodel);
		/*}}}*/
		/*Element virtual functions definitions: {{{1*/
		void   AverageOntoPartition(Vec partition_contributions,Vec partition_areas,double* vertex_response,double* qmu_part);
		void   ComputeBasalStress(Vec sigma_b);
		void   ComputeStrainRate(Vec eps);
		void   Configure(Elements* elements,Loads* loads,DataSet* nodes,Materials* materials,Parameters* parameters);
		void   SetCurrentConfiguration(Elements* elements,Loads* loads,DataSet* nodes,Materials* materials,Parameters* parameters);
		double RegularizeInversion(void);
		void   CreateKMatrix(Mat Kgg, Mat Kff, Mat Kfs,Vec dg,Vec df);
		void   CreatePVector(Vec pg, Vec pf);
		double DragCoefficientAbsGradient(bool process_units,int weight_index);
		int    GetNodeIndex(Node* node);
		int    Sid();
		bool   IsOnBed();
		bool   IsOnShelf(); 
		bool   IsNodeOnShelf(); 
		bool   IsNodeOnShelfFromFlags(double* flags);
		bool   IsOnWater(); 
		void   GetSolutionFromInputs(Vec solution);
		void   GetVectorFromInputs(Vec vector,int NameEnum);
		void   Gradj(Vec gradient,int control_type);
		void   GradjBMacAyeal(Vec gradient);
		void   GradjDragMacAyeal(Vec gradient);
		void   GradjDragStokes(Vec gradient);
		void   GradjDhDtBalancedthickness(Vec gradient);
		void   GradjVxBalancedthickness(Vec gradient);
		void   GradjVyBalancedthickness(Vec gradient);
		void   InputControlUpdate(double scalar,bool save_parameter);
		void   InputArtificialNoise(int enum_type,double min, double max);
		bool   InputConvergence(double* eps, int* enums,int num_enums,int* criterionenums,double* criterionvalues,int num_criterionenums);
		void   InputDepthAverageAtBase(int enum_type,int average_enum_type,int object_enum=ElementsEnum);
		void   InputDuplicate(int original_enum,int new_enum);
		void   InputScale(int enum_type,double scale_factor);
		void   ControlInputGetGradient(Vec gradient,int enum_type);
		void   ControlInputScaleGradient(int enum_type,double scale);
		void   ControlInputSetGradient(double* gradient,int enum_type);
		void   InputToResult(int enum_type,int step,double time);
		void   DeleteResults(void);
		void   MaterialUpdateFromTemperature(void){_error_("not implemented yet");};
		double MassFlux(double* segment,bool process_units);
		void   MaxAbsVx(double* pmaxabsvx, bool process_units);
		void   MaxAbsVy(double* pmaxabsvy, bool process_units);
		void   MaxAbsVz(double* pmaxabsvz, bool process_units);
		void   MaxVel(double* pmaxvel, bool process_units);
		void   MaxVx(double* pmaxvx, bool process_units);
		void   MaxVy(double* pmaxvy, bool process_units);
		void   MaxVz(double* pmaxvz, bool process_units);
		void   AgressiveMigration();
		void   SoftMigration(double* sheet_ungrounding);
		void   ShelfSync();
		void   PotentialSheetUngrounding(Vec potential_sheet_ungrounding);
		void   MigrateGroundingLine();
		void   MinVel(double* pminvel, bool process_units);
		void   MinVx(double* pminvx, bool process_units);
		void   MinVy(double* pminvy, bool process_units);
		void   MinVz(double* pminvz, bool process_units);
		double RheologyBbarAbsGradient(bool process_units,int weight_index);
		double ThicknessAbsMisfit(     bool process_units,int weight_index);
		double SurfaceAbsVelMisfit(    bool process_units,int weight_index);
		double ThicknessAbsGradient(bool process_units,int weight_index);
		double SurfaceRelVelMisfit(    bool process_units,int weight_index);
		double SurfaceLogVelMisfit(    bool process_units,int weight_index);
		double SurfaceLogVxVyMisfit(   bool process_units,int weight_index);
		double SurfaceAverageVelMisfit(bool process_units,int weight_index);
		void   PatchFill(int* pcount, Patch* patch);
		void   PatchSize(int* pnumrows, int* pnumvertices,int* pnumnodes);
		void   ProcessResultsUnits(void);
		double SurfaceArea(void);
		void   Update(int index, IoModel* iomodel,int analysis_counter,int analysis_type);
		void   UpdateForcing(int index, IoModel* iomodel,int step,double time, int FieldEnum,Parameters* parameters);
		int    UpdateShelfStatus(Vec new_shelf_nodes);
		int    UpdatePotentialSheetUngrounding(double* potential_sheet_ungrounding,Vec vec_nodes_on_iceshelf,double* nodes_on_iceshelf);
		void   UpdateShelfFlags(double* new_shelf_nodes);
		double TimeAdapt();
		int*   GetHorizontalNeighboorSids(void);
		/*}}}*/
		/*Tria specific routines:{{{1*/
		ElementMatrix* CreateKMatrixAdjointBalancethickness(void);
		ElementMatrix* CreateKMatrixBalancethickness(void);
		ElementMatrix* CreateKMatrixBalancethickness_DG(void);
		ElementMatrix* CreateKMatrixBalancethickness_CG(void);
		ElementMatrix* CreateKMatrixBalancevelocities(void);
		ElementMatrix* CreateKMatrixDiagnosticMacAyeal(void);
		ElementMatrix* CreateKMatrixDiagnosticMacAyealViscous(void);
		ElementMatrix* CreateKMatrixDiagnosticMacAyealFriction(void);
		ElementMatrix* CreateKMatrixDiagnosticHutter(void);
		ElementMatrix* CreateKMatrixMelting(void);
		ElementMatrix* CreateKMatrixHydrology(void);
		ElementMatrix* CreateKMatrixPrognostic(void);
		ElementMatrix* CreateKMatrixPrognostic_CG(void);
		ElementMatrix* CreateKMatrixPrognostic_DG(void);
		ElementMatrix* CreateKMatrixSlope(void);
		ElementVector* CreatePVectorBalancethickness(void);
		ElementVector* CreatePVectorBalancethickness_DG(void);
		ElementVector* CreatePVectorBalancethickness_CG(void);
		ElementVector* CreatePVectorBalancevelocities(void);
		ElementVector* CreatePVectorDiagnosticMacAyeal(void);
		ElementVector* CreatePVectorAdjointHoriz(void);
		ElementVector* CreatePVectorAdjointStokes(void);
		ElementVector* CreatePVectorAdjointBalancethickness(void);
		ElementVector* CreatePVectorDiagnosticHutter(void);
		ElementVector* CreatePVectorHydrology(void);
		ElementVector* CreatePVectorPrognostic(void);
		ElementVector* CreatePVectorPrognostic_CG(void);
		ElementVector* CreatePVectorPrognostic_DG(void);
		ElementVector* CreatePVectorSlope(void);
		double  GetArea(void);
		int     GetElementType(void);
		void	  GetDofList(int** pdoflist,int approximation_enum,int setenum);
		void	  GetDofList1(int* doflist);
		void    GetSidList(int* sidlist);
		void    GetParameterListOnVertices(double* pvalue,int enumtype);
		void    GetParameterListOnVertices(double* pvalue,int enumtype,double defaultvalue);
		void    GetParameterListOnVertices(double* pvalue,int enumtype,double defaultvalue,int index); //TO BE REMOVED
		void    GetParameterValue(double* pvalue,Node* node,int enumtype);
		void	  GetSolutionFromInputsDiagnosticHoriz(Vec solution);
		void	  GetSolutionFromInputsDiagnosticHutter(Vec solution);
		void	  GetSolutionFromInputsHydrology(Vec solution);
		void    GetStrainRate2d(double* epsilon,double* xyz_list, GaussTria* gauss, Input* vx_input, Input* vy_input);
		void	  InputUpdateFromSolutionAdjointBalancethickness( double* solution);
		void	  InputUpdateFromSolutionAdjointHoriz( double* solution);
		void	  InputUpdateFromSolutionDiagnosticHoriz( double* solution);
		void	  InputUpdateFromSolutionDiagnosticHutter( double* solution);
		void	  InputUpdateFromSolutionOneDof(double* solution,int enum_type);
		void	  InputUpdateFromSolutionPrognostic(double* solution);
		void	  InputUpdateFromSolutionHydrology(double* solution);
		bool	  IsInput(int name);
		void	  SetClone(int* minranks);
		void	  SurfaceNormal(double* surface_normal, double xyz_list[3][3]);
		void      GetHydrologyK(double* K,double* xyz_list,GaussTria* gauss);
		/*}}}*/

};
#endif  /* _TRIA_H */
