%This test is a test from the ISMP-HOM Intercomparison project
%Pattyn and Payne 2006

L_list={5000,10000,20000,40000,80000,160000};
results={};

for i=1:length(L_list),
	L=L_list{i};
	nx=20; %numberof nodes in x direction
	ny=20;
	md=model;
	md=squaremesh(md,L,L,nx,ny);
	md=geography(md,'',''); %ice sheet test
	md=parameterize(md,'../Par/ISMIPB.par');
	md=extrude(md,10,1);

	md=setelementstype(md,'pattyn','all','stokes','all');

	%Create dirichlet on the bed only
	md.spcvelocity=zeros(md.numberofnodes,6);
	pos=find(md.nodeonbed);
	md.spcvelocity(pos,1:2)=1;

	%Create MPCs to have periodic boundary conditions
	posx=find(md.x==0);
	posx2=find(md.x==max(md.x));

	posy=find(md.y==0 & md.x~=0 & md.x~=max(md.x)); %Don't take the same nodes two times
	posy2=find(md.y==max(md.y) & md.x~=0 & md.x~=max(md.x));

	md.penalties=[posx,posx2;posy,posy2];

	%Compute the diagnostic
	md.cluster=generic('name',oshostname(),'np',8);
	md=solve(md,DiagnosticSolutionEnum);

	%Plot the results and save them
	vx=PatchToVec(md.results.DiagnosticSolution.Vx);
	vy=PatchToVec(md.results.DiagnosticSolution.Vy);
	vz=PatchToVec(md.results.DiagnosticSolution.Vz);
	results{i}=md.results.DiagnosticSolution;

	plotmodel(md,'data',vx,'data',vy,'data',vz,'layer#all',md.numlayers)
end

%Fields and tolerances to track changes
field_names     ={...
	'Vx5km','Vy5km','Vz5km',...
	'Vx10km','Vy10km','Vz10km',...
	'Vx20km','Vy20km','Vz20km',...
	'Vx40km','Vy40km','Vz40km',...
	'Vx80km','Vy80km','Vz80km',...
	'Vx160km','Vy160km','Vz160km'
};
field_tolerances={...
	1e-08,1e-08,1e-08,...
	1e-08,1e-08,1e-08,...
	1e-08,1e-08,1e-08,...
	1e-08,1e-08,1e-08,...
	1e-08,1e-08,1e-08,...
	1e-08,1e-07,1e-08,...
};
field_values={};
for i=1:6,
	result=results{i};
	field_values={field_values{:},...
		PatchToVec(result.Vx),...
		PatchToVec(result.Vy),...
		PatchToVec(result.Vz),...
		};
end
