/*!\file CostFunctionx
 * \brief: compute misfit between observations and model
 */

#include "./CostFunctionx.h"

#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../Responsex/Responsex.h"

void CostFunctionx( double* pJ, Elements* elements,Nodes* nodes, Vertices* vertices, Loads* loads, Materials* materials,Parameters* parameters){

	/*Intermediary*/
	int    i;
	int     num_responses;
	double S;
	Element* element=NULL;
	int*     responses=NULL;

	/*output: */
	double J,Jplus;

	
	/*Recover parameters*/
	parameters->FindParam(&num_responses,NumResponsesEnum);
	parameters->FindParam(&responses,NULL,NULL,StepResponsesEnum);

	/*Get response*/
	J=0;
	for(int i=0;i<num_responses;i++){
		Responsex(&Jplus,elements,nodes,vertices,loads,materials,parameters,EnumToStringx(responses[i]),false,i); //False means DO NOT process units
		J+=Jplus;
	}

	/*REST TO BE DELETED*/

	/*Add Regularization terms: */
	double Jreg=0;
	double Jreg_sum;
	for (i=0;i<elements->Size();i++){
		element=(Element*)elements->GetObjectByOffset(i);
		Jreg+=element->RegularizeInversion();
	}

	/*Sum all J from all cpus of the cluster:*/
	MPI_Reduce (&Jreg,&Jreg_sum,1,MPI_DOUBLE,MPI_SUM,0,MPI_COMM_WORLD );
	MPI_Bcast(&Jreg_sum,1,MPI_DOUBLE,0,MPI_COMM_WORLD); 
	J=J+Jreg_sum;

	/*Assign output pointers: */
	xfree((void**)&responses);
	*pJ=J;
}
