/*! \file TriaVertexInput.h 
 *  \brief: header file for triavertexinput object
 */


#ifndef _TRIAVERTEXINPUT_H_
#define _TRIAVERTEXINPUT_H_

/*Headers:*/
/*{{{1*/
#include "./Input.h"
#include "../Elements/TriaRef.h"
class GaussTria;
/*}}}*/

class TriaVertexInput: public Input,public TriaRef{

	public:
		/*just hold 3 values for 3 vertices: */
		int    enum_type;
		double values[3];

		/*TriaVertexInput constructors, destructors: {{{1*/
		TriaVertexInput();
		TriaVertexInput(int enum_type,double* values);
		~TriaVertexInput();
		/*}}}*/
		/*Object virtual functions definitions:{{{1 */
		void  Echo();
		void  DeepEcho();
		int   Id(); 
		int   MyRank();
		void  Marshall(char** pmarshalled_dataset);
		int   MarshallSize();
		void  Demarshall(char** pmarshalled_dataset);
		int   Enum();
		Object* copy();
		/*}}}*/
		/*TriaVertexInput management: {{{1*/
		int   EnumType();
		Input* SpawnTriaInput(int* indices);
		Input* PointwiseDivide(Input* inputB){_error_("not implemented yet");};
		Input* PointwiseMin(Input* inputB);
		Input* PointwiseMax(Input* inputB);
		ElementResult* SpawnResult(int step, double time);
		void AddTimeValues(double* values,int step,double time){_error_("not supported yet");};
		void Configure(Parameters* parameters);
		/*}}}*/
		/*numerics: {{{1*/
		void GetParameterValue(bool* pvalue){_error_("not implemented yet");}
		void GetParameterValue(int* pvalue){_error_("not implemented yet");}
		void GetParameterValue(double* pvalue){_error_("not implemented yet");}
		void GetParameterValue(double* pvalue,GaussTria* gauss);
		void GetParameterValue(double* pvalue,GaussPenta* gauss){_error_("not implemented yet");};
		void GetParameterValue(double* pvalue,GaussTria* gauss ,int index){_error_("not implemented yet");};
		void GetParameterValue(double* pvalue,GaussPenta* gauss,int index){_error_("not implemented yet");};
		void GetParameterDerivativeValue(double* derivativevalues, double* xyz_list, GaussTria* gauss);
		void GetParameterDerivativeValue(double* derivativevalues, double* xyz_list, GaussPenta* gauss){_error_("not implemented yet");};
		void GetParameterAverage(double* pvalue);
		void GetVxStrainRate2d(double* epsilonvx,double* xyz_list, GaussTria* gauss);
		void GetVyStrainRate2d(double* epsilonvy,double* xyz_list, GaussTria* gauss);
		void GetVxStrainRate3d(double* epsilonvx,double* xyz_list, GaussPenta* gauss){_error_("not implemented yet");};
		void GetVyStrainRate3d(double* epsilonvy,double* xyz_list, GaussPenta* gauss){_error_("not implemented yet");};
		void GetVzStrainRate3d(double* epsilonvz,double* xyz_list, GaussPenta* gauss){_error_("not implemented yet");};
		void GetVxStrainRate3dPattyn(double* epsilonvx,double* xyz_list, GaussPenta* gauss){_error_("not implemented yet");};
		void GetVyStrainRate3dPattyn(double* epsilonvy,double* xyz_list, GaussPenta* gauss){_error_("not implemented yet");};
		void ChangeEnum(int newenumtype);

		void SquareMin(double* psquaremin, bool process_units,Parameters* parameters);
		void ConstrainMin(double minimum);
		void Scale(double scale_factor);
		void ArtificialNoise(double min,double max);
		void AXPY(Input* xinput,double scalar);
		void Constrain(double cm_min, double cm_max);
		double InfinityNorm(void);
		double Max(void);
		double MaxAbs(void);
		double Min(void);
		double MinAbs(void);
		void Extrude(void){_error_("not supported yet");};
		void VerticallyIntegrate(Input* thickness_input){_error_("not supported yet");};
		void GetVectorFromInputs(Vec vector,int* doflist);
		void GetValuesPtr(double** pvalues,int* pnum_values);
		/*}}}*/

};
#endif  /* _TRIAVERTEXINPUT_H */
