md=mesh(model,'../Exp/Pig.exp',30000);
md=geography(md,'../Exp/PigShelves.exp','../Exp/PigIslands.exp');
md=parameterize(md,'../Par/Pig.par');
md=extrude(md,3,1);
md=setelementstype(md,'pattyn','all');
md.artificial_diffusivity=2;
md.cluster=generic('name',oshostname(),'np',3);
md=solve(md,ThermalSolutionEnum);

%Fields and tolerances to track changes
field_names     ={'Temperature1','BasalMeltingRate1', ...
				      'Temperature2','BasalMeltingRate2'};
field_tolerances={1e-13,1e-8,1e-13,1e-8};
field_values={...
	PatchToVec(md.results.ThermalSolution(1).Temperature),...
	PatchToVec(md.results.ThermalSolution(1).BasalMeltingRate),...
	PatchToVec(md.results.ThermalSolution(2).Temperature),...
	PatchToVec(md.results.ThermalSolution(2).BasalMeltingRate),...
	};
