md=mesh(model,'../Exp/Square.exp',150000);
md=geography(md,'all','');
md=parameterize(md,'../Par/SquareShelfConstrained.par');
md=extrude(md,5,1);
%Add boundary conditions on thickness on the border
pos=find(md.nodeonboundary);
md.spcthickness(pos,1)=1;
md.spcthickness(pos,2)=md.thickness(pos);
md=setelementstype(md,'macayeal','all');
md.cluster=generic('np',3);
md=solve(md,BalancethicknessSolutionEnum);

%Fields and tolerances to track changes
field_names     ={'Thickness'};
field_tolerances={1e-13};
field_values={...
	PatchToVec(md.results.BalancethicknessSolution.Thickness),...
	};
