md=mesh(model,'../Exp/Square.exp',180000);
md=geography(md,'all','');
md=parameterize(md,'../Par/SquareShelf.par');
md=extrude(md,3,1);
md=setelementstype(md,'macayeal','all');
md.cluster=generic('np',3);
md=solve(md,ThermalSolutionEnum);

%Fields and tolerances to track changes
field_names     ={'Temperature1','BasalMeltingRate1','Temperature2','BasalMeltingRate2','Temperature3','BasalMeltingRate3'};
field_tolerances={1e-13,1e-13,1e-13,1e-13,1e-13,1e-13};
field_values={...
	PatchToVec(md.results.ThermalSolution(1).Temperature),...
	PatchToVec(md.results.ThermalSolution(1).BasalMeltingRate),...
	PatchToVec(md.results.ThermalSolution(2).Temperature),...
	PatchToVec(md.results.ThermalSolution(2).BasalMeltingRate),...
	PatchToVec(md.results.ThermalSolution(3).Temperature),...
	PatchToVec(md.results.ThermalSolution(3).BasalMeltingRate),...
	};
