md=mesh(model,'../Exp/Pig.exp',20000);
md=geography(md,'../Exp/PigShelves.exp','../Exp/PigIslands.exp');
md=parameterize(md,'../Par/Pig.par');
md=extrude(md,2,1);
md=setelementstype(md,'stokes','all');
md.cluster=generic('np',3);
md.dt=0;
md=solve(md,SteadystateSolutionEnum);

%Fields and tolerances to track changes
field_names     ={'Vx','Vy','Vz','Vel','Pressure','Temperature','BasalMeltingRate'};
field_tolerances={1e-08,1e-08,1e-08,1e-08,1e-08,1e-08,1e-06
};
field_values={...
	PatchToVec(md.results.SteadystateSolution.Vx),...
	PatchToVec(md.results.SteadystateSolution.Vy),...
	PatchToVec(md.results.SteadystateSolution.Vz),...
	PatchToVec(md.results.SteadystateSolution.Vel),...
	PatchToVec(md.results.SteadystateSolution.Pressure),...
	PatchToVec(md.results.SteadystateSolution.Temperature),...
	PatchToVec(md.results.SteadystateSolution.BasalMeltingRate),...
	};
