function md=solve(md,solutionenum,varargin)
%SOLVE - apply solution sequence for this model
%
%   Usage:
%      md=solve(md,solutionenum,varargin)
%      where varargin is a lit of paired arguments of string OR enums
%
%      solution types available comprise:
%		DiagnosticSolutionEnum
%		PrognosticSolutionEnum
%		ThermalSolutionEnum
%		SteadystateSolutionEnum
%		ParametersSolutionEnum
%		TransientSolutionEnum...
%		BalancethicknessSolutionEnum
%		BalancevelocitiesSolutionEnum
%		BedSlopeSolutionEnum
%		SurfaceSlopeSolutionEnum
%		GroundingLineMigration2DSolutionEnum
%		HydrologySolutionEnum
%		FlaimSolutionEnum
%
%   Examples:
%      md=solve(md,DiagnosticSolutionEnum);

%recover options
options=pairoptions(varargin{:},'solution_type',solutionenum);

%add default options
options=process_solve_options(options);

%recover some fields
md.solution_type=options.solution_type;

%check model consistency
disp('checking model consistency');
ismodelselfconsistent(md),

%if running qmu analysis, some preprocessing of dakota files using 
%models fields needs to be carried out. 
if md.qmu_analysis,
	md=preqmu(md,options);
end

%preprocesses model before solving
md=presolve(md);

%Save model as is (in case of a crash)
assignin('base',inputname(1),md);

%flaim analysis
if (md.solution_type == FlaimSolutionEnum)
	md=flaim(md,options);
	md.solution_type=EnumToString(options.solution_type);
	return;
end

%Marshall model data into a binary file.
marshall(md);

%add qmu fields to binary file if running qmu analysis
if md.qmu_analysis,
	qmumarshall(md,md.variables(options.ivar),md.responses(options.iresp));
end

%write a template file for issm to use, in parallel
PetscOptions2PetscFile(md.petscoptions,[md.name '.petsc']);

%If running in parallel, we have a different way of launching the solution
%sequences. 
if ~strcmpi(md.cluster.name,'none'),
	md=solveparallel(md,options);
	return;
end

%Launch correct solution sequence
md=issm(md,md.solution_type);

%post processes qmu results if necessary
if md.qmu_analysis,
	md=postqmu(md);
	cd ..
	if ~strncmpi(options.keep,'y',1)
		system(['rm -rf qmu' num2str(feature('GetPid'))]);
	end
end

%Check result is consistent
%disp('checking result consistency');
%if ~isresultconsistent(md,options.solution_type),
%	disp('!! results not consistent correct the model !!') %it would be very cruel to put an error, it would kill the computed results (even if not consistent...)
%end

%convert analysis type to string finally
md.solution_type=EnumToString(options.solution_type);
