#!/bin/bash

#get number of CPUS
NUMCPUS=$1;

#version of metis
version=`echo *.tar.gz | sed 's/\.tar\.gz//g' | sed 's/metis-//g'`
echo $version

#Some cleanup
rm -rf install metis-$version

#Create install directories
mkdir install

#Untar 
tar -zxvf  metis-$version.tar.gz

#Move metis into install directory
mv metis-$version/* install
rm -rf metis-$version

#Apply patches
cd install 
patch -p1 < ../metis-4.0.patch

#Compile metis
if [ -z $NUMCPUS ];
then
	make
else
	make -j $NUMCPUS
fi
