/*
 * UpdateElementsTransient:
 */

#include "../../../Container/Container.h"
#include "../../../toolkits/toolkits.h"
#include "../../../io/io.h"
#include "../../../EnumDefinitions/EnumDefinitions.h"
#include "../../../objects/objects.h"
#include "../../../shared/shared.h"
#include "../../MeshPartitionx/MeshPartitionx.h"
#include "../../../include/include.h"
#include "../ModelProcessorx.h"

void	UpdateElementsTransient(Elements* elements, Parameters* parameters,IoModel* iomodel,FILE* iomodel_handle,int analysis_counter,int analysis_type){

	/*Intermediary*/
	int      i,j,k;
	int      counter;
	Element *element = NULL;
	char     fetchstring[100]; 
	double   time;
	double   forcingenum;

	/*if no forcings, bail out: */
	if(!iomodel->numforcings)return;

	/*download whatever data will persist through forcing loop: */
	IoModelFetchData(&iomodel->elements,NULL,NULL,iomodel_handle,"elements");
	
	/*download forcing types: */
	IoModelFetchData(&iomodel->forcingtypes,NULL,NULL,iomodel_handle,"forcingtypes");

	/*loop over forcings: */
	for(i=0;i<iomodel->numforcings;i++){

		forcingenum=iomodel->forcingtypes[i];
		
		sprintf(&fetchstring[0],"forcing_%s_num_time_steps",EnumToStringx(forcingenum));
		IoModelFetchData(&iomodel->forcing_numtimesteps,iomodel_handle,fetchstring);
		sprintf(&fetchstring[0],"forcing_%s_time_steps",EnumToStringx(forcingenum));
		IoModelFetchData(&iomodel->timesteps,NULL,NULL,iomodel_handle,fetchstring);

		for(j=0;j<iomodel->forcing_numtimesteps;j++){
		
			time=iomodel->timesteps[j]*iomodel->yts;
			sprintf(&fetchstring[0],"forcing_%s_%i",EnumToStringx(forcingenum),j+1);
			IoModelFetchData(&iomodel->forcing,NULL,NULL,iomodel_handle,fetchstring);

			/*we now have the forcing for the corresponding time step, for all the nodes. Use this 
			 *to write over the existing smb input: */
			counter=0;
			for (k=0;k<iomodel->numberofelements;k++){
				if(iomodel->my_elements[k]){
					element=(Element*)elements->GetObjectByOffset(counter);
					element->UpdateForcing(k,iomodel,j,time,forcingenum,parameters);
					counter++;
				}
			}
			/*Free ressources:*/
			xfree((void**)&iomodel->forcing);
		}

		/*Free ressources:*/
		xfree((void**)&iomodel->timesteps);
	}

	/*Free ressources:*/
	xfree((void**)&iomodel->forcing);
	xfree((void**)&iomodel->timesteps);
	xfree((void**)&iomodel->elements);
	xfree((void**)&iomodel->forcingtypes);
}
