/*!\file OptionStruct.cpp
 * \brief: implementation of the optionsstruct object
 */

/*Headers:*/
/*{{{1*/
#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "stdio.h"
#include <string.h>
#include "../objects.h"
#include "../../shared/shared.h"
#include "../../Container/Container.h"
#include "../../include/include.h"
/*}}}*/

/*Constructors/destructor/copy*/
/*FUNCTION OptionStruct::OptionStruct(){{{1*/
OptionStruct::OptionStruct(){

	values    =NULL;

}
/*}}}*/
/*FUNCTION OptionStruct::~OptionStruct(){{{1*/
OptionStruct::~OptionStruct(){

	int   i;

	if(values){
		for(i=0; i<numel; i++) {
			delete values[i];
			values[i] =NULL;
		}
		xfree((void**)&values);
	}

}
/*}}}*/

/*Other*/
/*FUNCTION OptionStruct::Echo {{{1*/
void  OptionStruct::Echo(){

	char  cstr[81];
	bool  flag=true;

	_printf_(flag,"OptionStruct Echo:\n");
	Option::Echo();

	if (values && size) {
		StringFromSize(cstr,size,ndims);
		_printf_(flag,"        values: %s %s\n" ,cstr,"struct");
	}
	else _printf_(flag,"        values: [empty]\n" );
}
/*}}}*/
/*FUNCTION OptionStruct::DeepEcho() {{{1*/
void  OptionStruct::DeepEcho(){

	char  indent[81]="";

	OptionStruct::DeepEcho(indent);

	return;
}
/*}}}*/
/*FUNCTION OptionStruct::DeepEcho(char* indent) {{{1*/
void  OptionStruct::DeepEcho(char* indent){

	int   i,j;
	int*  dims;
	char  indent2[81];
	char  cstr[81];
	bool  flag=true;

	_printf_(flag,"%sOptionStruct DeepEcho:\n",indent);
	Option::DeepEcho(indent);

	strcpy(indent2,indent);
	strcat(indent2,"  ");

	if (values) {
		dims=(int *)xmalloc(ndims*sizeof(int));
		for (i=0; i<numel; i++) {
			ColumnWiseDimsFromIndex(dims,i,size,ndims);
			StringFromDims(cstr,dims,ndims);
			if (values[i]->Size()){
				_printf_(flag,"%s        values: -------- begin %s --------\n" ,indent,cstr);
				for (j=0; j<values[i]->Size(); j++) ((Option *)values[i]->GetObjectByOffset(j))->DeepEcho(indent2);
				_printf_(flag,"%s        values: --------  end  %s --------\n" ,indent,cstr);
			}
			else _printf_(flag,"%s        values: %s [empty]\n" ,indent,cstr);
		}
		xfree((void**)&dims);
	}
	else _printf_(flag,"%s        values: [empty]\n" ,indent);
}
/*}}}*/
/*FUNCTION OptionStruct::Name {{{1*/
char* OptionStruct::Name(){

	return(Option::Name());
}
/*}}}*/
/*FUNCTION OptionStruct::NumEl {{{1*/
int   OptionStruct::NumEl(){

	return(Option::NumEl());
}
/*}}}*/
/*FUNCTION OptionStruct::NDims {{{1*/
int   OptionStruct::NDims(){

	return(Option::NDims());
}
/*}}}*/
/*FUNCTION OptionStruct::Size {{{1*/
int*  OptionStruct::Size(){

	return(Option::Size());
}
/*}}}*/
/*FUNCTION OptionStruct::Get(Options** pvalue) {{{1*/
void OptionStruct::Get(Options** pvalue){

	/*We should first check that the size is one*/
	if(this->NumEl()!=1){
		_error_("option \"%s\" has %i elements and cannot return a single options dataset",this->name,this->NumEl());
	}

	/*Assign output pointer*/
	*pvalue=this->values[0];
}
/*}}}*/
/*FUNCTION OptionStruct::Get(Options*** pvalue,int* numel) {{{1*/
void OptionStruct::Get(Options*** pvalue,int* numel){

	/*We should first check that the size is at least one*/
	if(this->NumEl()<=0){
		_error_("option \"%s\" is empty and cannot return an options dataset vector",this->name);
	}

	/*Assign output pointer*/
	*pvalue=this->values;
	if(numel) *numel=this->NumEl();
}
/*}}}*/
