/*!\file OptionDouble.cpp
 * \brief: implementation of the optionsdouble object
 */

/*Headers:*/
/*{{{1*/
#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "stdio.h"
#include <string.h>
#include "../objects.h"
#include "../../shared/shared.h"
#include "../../Container/Container.h"
#include "../../include/include.h"
/*}}}*/

/*Constructors/destructor/copy*/
/*FUNCTION OptionDouble::OptionDouble(){{{1*/
OptionDouble::OptionDouble(){

	values    =NULL;

}
/*}}}*/
/*FUNCTION OptionDouble::~OptionDouble(){{{1*/
OptionDouble::~OptionDouble(){

	if (values) xfree((void**)&values);

}
/*}}}*/

/*Other*/
/*FUNCTION OptionDouble::Echo {{{1*/
void  OptionDouble::Echo(){

	char  cstr[81];
	bool  flag=true;

	_printf_(flag,"OptionDouble Echo:\n");
	Option::Echo();

	if (values && size) {
		if(numel == 1) _printf_(flag,"        values: %g\n" ,values[0]);
		else {
			StringFromSize(cstr,size,ndims);
			_printf_(flag,"        values: %s %s\n" ,cstr,"double");
		}
	}
	else _printf_(flag,"        values: [empty]\n" );
}
/*}}}*/
/*FUNCTION OptionDouble::DeepEcho() {{{1*/
void  OptionDouble::DeepEcho(){

	char  indent[81]="";

	OptionDouble::DeepEcho(indent);

	return;
}
/*}}}*/
/*FUNCTION OptionDouble::DeepEcho(char* indent) {{{1*/
void  OptionDouble::DeepEcho(char* indent){

	int   i;
	int*  dims;
	char  indent2[81];
	char  cstr[81];
	bool  flag=true;

	_printf_(flag,"%sOptionDouble DeepEcho:\n",indent);
	Option::DeepEcho(indent);

	strcpy(indent2,indent);
	strcat(indent2,"  ");

	if (values) {
		dims=(int *) xmalloc(ndims*sizeof(int));
		if(numel==1) _printf_(flag,"%s        values: %g\n" ,indent,values[0]);
		else{
			for (i=0; i<numel; i++) {
				RowWiseDimsFromIndex(dims,i,size,ndims);
				StringFromDims(cstr,dims,ndims);
				_printf_(flag,"%s        values%s: %g\n" ,indent,cstr,values[i]);
			}
		}
		xfree((void**)&dims);
	}
	else _printf_(flag,"%s        values: [empty]\n" ,indent);
}
/*}}}*/
/*FUNCTION OptionDouble::Name {{{1*/
char* OptionDouble::Name(){

	return(Option::Name());
}
/*}}}*/
/*FUNCTION OptionDouble::NumEl {{{1*/
int   OptionDouble::NumEl(){

	return(Option::NumEl());
}
/*}}}*/
/*FUNCTION OptionDouble::NDims {{{1*/
int   OptionDouble::NDims(){

	return(Option::NDims());
}
/*}}}*/
/*FUNCTION OptionDouble::Size {{{1*/
int*  OptionDouble::Size(){

	return(Option::Size());
}
/*}}}*/
/*FUNCTION OptionDouble::Get(double* pvalue) {{{1*/
void OptionDouble::Get(double* pvalue){

	/*We should first check that the size is one*/
	if(this->NumEl()!=1){
		_error_("option \"%s\" has %i elements and cannot return a single double",this->name,this->NumEl());
	}

	/*Assign output pointer*/
	*pvalue=this->values[0];
}
/*}}}*/
/*FUNCTION OptionDouble::Get(double** pvalue,int* numel) {{{1*/
void OptionDouble::Get(double** pvalue,int* numel){

	/*We should first check that the size is at least one*/
	if(this->NumEl()<=0){
		_error_("option \"%s\" is empty and cannot return a double vector",this->name);
	}

	/*Copy vector*/
	double* outvalue=(double*)xmalloc(this->NumEl()*sizeof(double));
	for(int i=0;i<this->NumEl();i++) outvalue[i]=this->values[i];

	/*Assign output pointer*/
	*pvalue=outvalue;
	if(numel) *numel=this->NumEl();
}
/*}}}*/
