/*! \file OptionLogical.h 
 *  \brief: header file for optionlogical object
 */

#ifndef _OPTIONLOGICAL_H_
#define _OPTIONLOGICAL_H_

/*Headers:{{{1*/
#include "../../include/include.h"
#include "../../shared/Exceptions/exceptions.h"
#include "../../EnumDefinitions/EnumDefinitions.h"

#include "./Option.h"
/*}}}*/

class OptionLogical: public Option {

	public:

		bool* values;

		/*OptionLogical constructors, destructors {{{1*/
		OptionLogical();
		~OptionLogical();
		/*}}}*/
		/*Object virtual functions definitions:{{{1*/
		void  Echo();
		void  DeepEcho();
		void  DeepEcho(char* indent);
		int   Id(){_error_("Not implemented yet");};
		int   MyRank(){_error_("Not implemented yet");};
		void  Marshall(char** pmarshalled_dataset){_error_("Not implemented yet");};
		int   MarshallSize(){_error_("Not implemented yet");};
		void  Demarshall(char** pmarshalled_dataset){_error_("Not implemented yet");};
		int   Enum(){return OptionLogicalEnum;};
		Object* copy(){_error_("Not implemented yet");};
		/*}}}*/

		/*virtual functions: */
		char* Name();
		int   NumEl();
		int   NDims();
		int*  Size();
		void  Get(double* pvalue){_error_("An OptionLogical object cannot return a double");};
		void  Get(bool* pvalue);
		void  Get(char** pvalue){ _error_("An OptionLogical object cannot return a string");};
		void  Get(double** pvalue,int *pnumel){ _error_("An OptionLogical object cannot return a double vec");};
		void  Get(Options** pvalue){ _error_("An OptionLogical object cannot return an Options DataSet");};
		void  Get(Options*** pvalue,int *pnumel){ _error_("An OptionLogical object cannot return an Options DataSet vec");};

};
#endif  /* _OPTIONLOGICAL_H */

