function [solutioncore]=CorePointerFromSolutionEnum(solutiontype),
%COREPOINTERFROMSOLUTIONENUM - returns solution_core function
%
%   Usage:
%      [solutioncore]=CorePointerFromSolutionEnum(solutiontype);

switch solutiontype,

	case DiagnosticSolutionEnum,               solutioncore='diagnostic_core';
	case SteadystateSolutionEnum,              solutioncore='steadystate_core';
	case ThermalSolutionEnum,                  solutioncore='thermal_core';
	case EnthalpySolutionEnum,                 solutioncore='enthalpy_core';
	case PrognosticSolutionEnum,               solutioncore='prognostic_core';
	case BalancethicknessSolutionEnum,         solutioncore='balancethickness_core';
	case BalancevelocitiesSolutionEnum,        solutioncore='balancevelocities_core';
	case SurfaceSlopeSolutionEnum,             solutioncore='surfaceslope_core';
	case BedSlopeSolutionEnum,                 solutioncore='bedslope_core';
	case TransientSolutionEnum,                solutioncore='transient_core';
	case FlaimSolutionEnum,                    solutioncore='flaim_core';
	case GroundingLineMigration2DSolutionEnum, solutioncore='DUMMYDUMMY'; %not working in serial mode
	case HydrologySolutionEnum,                solutioncore='DUMMYDUMMY'; %not working in serial mode
	otherwise error('%s%s%s',' solution type: ',EnumToString(solutiontype),' not supported yet!');

end
