/*!\file UpdateNodePositionsx
 * \brief update node positions using new geometry defined by new thickness and new bed.
 */

#include "./UpdateNodePositionsx.h"

#undef __FUNCT__ 
#define __FUNCT__ "UpdateNodePositionsx"

#include "../shared/shared.h"
#include "../include/macros.h"
#include "../toolkits/toolkits.h"
#include "../EnumDefinitions/EnumDefinitions.h"

void UpdateNodePositionsx( DataSet* elements,DataSet* nodes,DataSet* loads, DataSet* materials, Vec thickness,Vec bed){

	/*intermediary: */
	double* thickness_serial=NULL;
	double* bed_serial=NULL;

	/*First, get elements and loads configured: */
	elements->Configure(elements,loads, nodes, materials);
	loads->Configure(elements, loads, nodes, materials);
	nodes->Configure(elements, loads, nodes, materials);

	/*serialize inputs: */
	VecToMPISerial(&thickness_serial,thickness);
	VecToMPISerial(&bed_serial,bed);
	
	/*Update elements, nodes, loads and materials from new geometry: */
	nodes->UpdateNodePositions(thickness_serial,bed_serial);

	/*Free ressources:*/
	xfree((void**)&thickness_serial);
	xfree((void**)&bed_serial);
}
