/* \file ModelProcessorx.h
 * \brief  Header file for model processor
 */

#ifndef _MODEL_PROCESSORX_H_
#define _MODEL_PROCESSORX_H_

#define RIFTINFOSIZE 12

class DataSet;
class IoModel;
class Parameters;
#include "../../io/io.h"

void ModelProcessorx(Elements** pelements, Nodes** pnodes, Vertices** pvertices, Materials** pmaterials, Constraints** pconstraints, Loads** ploads, Parameters** pparameters, FILE* iomodel_handle,const int solution_type,const int nummodels,const int* analysis_type_list);

/*Creation of fem datasets: general drivers*/
void  CreateDataSets(Elements** pelements,Nodes** pnodes,Vertices** pvertices, Materials** pmaterials, Constraints** pconstraints, Loads** ploads,Parameters** pparameters,IoModel* iomodel,FILE* iomodel_handle,const int solution_type,int analysis_type,const int nummodels,int analysis_counter);
void  CreateElementsVerticesAndMaterials(Elements** pelements,Vertices** pvertices,Materials** pmaterials, IoModel* iomodel,FILE* iomodel_handle,const int nummodels);
void  CreateParameters(Parameters** pparameters,IoModel* iomodel,FILE* iomodel_handle,const int solution_type,int analysis_type,int analysis_counter);
void  CreateParametersControl(Parameters** pparameters,IoModel* iomodel,FILE* iomodel_handle,int solution_type,int analysis_type);
void  CreateParametersQmu(Parameters** pparameters,IoModel* iomodel,FILE* iomodel_handle,int solution_type,int analysis_type);
void  UpdateElementsAndMaterialsControl(Elements* elements,Materials* materials, IoModel* iomodel,FILE* iomodel_handle);

/*Creation of fem datasets: specialised drivers: */

/*diagnostic horizontal*/
void	CreateNodesDiagnosticHoriz(Nodes** pnodes,IoModel* iomodel,FILE* iomodel_handle);
void	CreateConstraintsDiagnosticHoriz(Constraints** pconstraints,IoModel* iomodel,FILE* iomodel_handle);
void  CreateLoadsDiagnosticHoriz(Loads** ploads, IoModel* iomodel, FILE* iomodel_handle);
void	UpdateElementsDiagnosticHoriz(Elements* elements,IoModel* iomodel,FILE* iomodel_handle,int analysis_counter,int analysis_type);

/*diagnostic vertical*/
void	CreateNodesDiagnosticVert(Nodes** pnodes,IoModel* iomodel,FILE* iomodel_handle);
void	CreateConstraintsDiagnosticVert(Constraints** pconstraints,IoModel* iomodel,FILE* iomodel_handle);
void  CreateLoadsDiagnosticVert(Loads** ploads, IoModel* iomodel, FILE* iomodel_handle);
void	UpdateElementsDiagnosticVert(Elements* elements,IoModel* iomodel,FILE* iomodel_handle,int analysis_counter,int analysis_type);

/*diagnostic hutter*/
void	CreateNodesDiagnosticHutter(Nodes** pnodes,IoModel* iomodel,FILE* iomodel_handle);
void	CreateConstraintsDiagnosticHutter(Constraints** pconstraints,IoModel* iomodel,FILE* iomodel_handle);
void  CreateLoadsDiagnosticHutter(Loads** ploads, IoModel* iomodel, FILE* iomodel_handle);
void	UpdateElementsDiagnosticHutter(Elements* elements,IoModel* iomodel,FILE* iomodel_handle,int analysis_counter,int analysis_type);

/*bed slope*/
void	CreateNodesBedSlope(Nodes** pnodes,IoModel* iomodel,FILE* iomodel_handle);
void	CreateConstraintsBedSlope(Constraints** pconstraints,IoModel* iomodel,FILE* iomodel_handle);
void  CreateLoadsBedSlope(Loads** ploads, IoModel* iomodel, FILE* iomodel_handle);
void	UpdateElementsBedSlope(Elements* elements,IoModel* iomodel,FILE* iomodel_handle,int analysis_counter,int analysis_type);

/*surface slope*/
void	CreateNodesSurfaceSlope(Nodes** pnodes,IoModel* iomodel,FILE* iomodel_handle);
void	CreateConstraintsSurfaceSlope(Constraints** pconstraints,IoModel* iomodel,FILE* iomodel_handle);
void  CreateLoadsSurfaceSlope(Loads** ploads, IoModel* iomodel, FILE* iomodel_handle);
void	UpdateElementsSurfaceSlope(Elements* elements,IoModel* iomodel,FILE* iomodel_handle,int analysis_counter,int analysis_type);

/*thermal:*/
void	CreateNodesThermal(Nodes** pnodes,IoModel* iomodel,FILE* iomodel_handle);
void	CreateConstraintsThermal(Constraints** pconstraints,IoModel* iomodel,FILE* iomodel_handle);
void  CreateLoadsThermal(Loads** ploads, IoModel* iomodel, FILE* iomodel_handle);
void	UpdateElementsThermal(Elements* elements,IoModel* iomodel,FILE* iomodel_handle,int analysis_counter,int analysis_type);

/*enthalpy:*/
void	CreateNodesEnthalpy(Nodes** pnodes,IoModel* iomodel,FILE* iomodel_handle);
void	CreateConstraintsEnthalpy(Constraints** pconstraints,IoModel* iomodel,FILE* iomodel_handle);
void  CreateLoadsEnthalpy(Loads** ploads, IoModel* iomodel, FILE* iomodel_handle);
void	UpdateElementsEnthalpy(Elements* elements,IoModel* iomodel,FILE* iomodel_handle,int analysis_counter,int analysis_type);

/*hydrology:*/
void	CreateNodesHydrology(Nodes** pnodes,IoModel* iomodel,FILE* iomodel_handle);
void	CreateConstraintsHydrology(Constraints** pconstraints,IoModel* iomodel,FILE* iomodel_handle);
void  CreateLoadsHydrology(Loads** ploads, IoModel* iomodel, FILE* iomodel_handle);
void	UpdateElementsHydrology(Elements* elements,IoModel* iomodel,FILE* iomodel_handle,int analysis_counter,int analysis_type);

/*melting:*/
void	CreateNodesMelting(Nodes** pnodes,IoModel* iomodel,FILE* iomodel_handle);
void	CreateConstraintsMelting(Constraints** pconstraints,IoModel* iomodel,FILE* iomodel_handle);
void  CreateLoadsMelting(Loads** ploads, IoModel* iomodel, FILE* iomodel_handle);
void	UpdateElementsMelting(Elements* elements,IoModel* iomodel,FILE* iomodel_handle,int analysis_counter,int analysis_type);

/*prognostic:*/
void	CreateNodesPrognostic(Nodes** pnodes,IoModel* iomodel,FILE* iomodel_handle);
void	CreateConstraintsPrognostic(Constraints** pconstraints,IoModel* iomodel,FILE* iomodel_handle);
void  CreateLoadsPrognostic(Loads** ploads, IoModel* iomodel, FILE* iomodel_handle);
void	UpdateElementsPrognostic(Elements* elements,IoModel* iomodel,FILE* iomodel_handle,int analysis_counter,int analysis_type);

/*balancedthickness:*/
void	CreateNodesBalancethickness(Nodes** pnodes,IoModel* iomodel,FILE* iomodel_handle);
void	CreateConstraintsBalancethickness(Constraints** pconstraints,IoModel* iomodel,FILE* iomodel_handle);
void  CreateLoadsBalancethickness(Loads** ploads, IoModel* iomodel, FILE* iomodel_handle);
void	UpdateElementsBalancethickness(Elements* elements,IoModel* iomodel,FILE* iomodel_handle,int analysis_counter,int analysis_type);

/*balancedvelocities:*/
void	CreateNodesBalancevelocities(Nodes** pnodes,IoModel* iomodel,FILE* iomodel_handle);
void	CreateConstraintsBalancevelocities(Constraints** pconstraints,IoModel* iomodel,FILE* iomodel_handle);
void  CreateLoadsBalancevelocities(Loads** ploads, IoModel* iomodel, FILE* iomodel_handle);
void	UpdateElementsBalancevelocities(Elements* elements,IoModel* iomodel,FILE* iomodel_handle,int analysis_counter,int analysis_type);

/*transient: */
void	UpdateElementsTransient(Elements* elements,Parameters* parameters,IoModel* iomodel,FILE* iomodel_handle,int analysis_counter,int analysis_type);

/*partitioning: */
void  ElementsAndVerticesPartitioning(bool** pmy_elements, int** pmy_vertices, IoModel* iomodel, FILE* iomodel_handle);
void  NodesPartitioning(bool** pmy_nodes,bool* my_elements, int* my_vertices,  IoModel* iomodel, FILE* iomodel_handle,bool continuous);

/*Connectivity*/
void  CreateSingleNodeToElementConnectivity(IoModel* iomodel);
void  CreateNumberNodeToElementConnectivity(IoModel* iomodel);

/*Diverse: */
void  SortDataSets(Elements** pelements,Nodes** pnodes,Vertices** pvertices, Loads** ploads, Materials** pmaterials, Constraints** pconstraints, Parameters** pparameters);
void  UpdateCounters(IoModel* iomodel,Nodes** pnodes,Loads** ploads, Constraints** pconstraints);


/*Distribution of dofs: */
void DistributeNumDofs(DofIndexing* index,int analysis_type,double* vertices_type);

#endif
