/*!\file:  DistributeNumDofs.cpp
 * \brief: figure out the maximum number of dofs per node.
 */ 

#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
	
void DistributeNumDofs(DofIndexing* index,int analysis_type,double* vertices_type){

	/*For now, we distribute by analysis_type, later, we will distribute using the analysis_type,
	 * but also the vertices_type: */

	int numdofs=2; //default numdofs
	int i;
	int* doftype=NULL;

	/*ok, according to analysis type: */
	if (analysis_type==DiagnosticHorizAnalysisEnum){
		if (vertices_type[0]==MacAyealApproximationEnum){
			numdofs=2;
		}
		else if (vertices_type[0]==PattynApproximationEnum){
			numdofs=2;
		}
		else if (vertices_type[0]==HutterApproximationEnum){
			numdofs=2;
		}
		else if (vertices_type[0]==StokesApproximationEnum){
			numdofs=4;
		}
		else if (vertices_type[0]==NoneApproximationEnum){
			numdofs=4;
		}
		else if (vertices_type[0]==MacAyealPattynApproximationEnum){
			numdofs=4;
			doftype=(int*)xmalloc(numdofs*sizeof(int));
			doftype[0]=MacAyealApproximationEnum;
			doftype[1]=MacAyealApproximationEnum;
			doftype[2]=PattynApproximationEnum;
			doftype[3]=PattynApproximationEnum;
		}
		else if (vertices_type[0]==PattynStokesApproximationEnum){
			numdofs=6;
			doftype=(int*)xmalloc(numdofs*sizeof(int));
			doftype[0]=PattynApproximationEnum;
			doftype[1]=PattynApproximationEnum;
			doftype[2]=StokesApproximationEnum;
			doftype[3]=StokesApproximationEnum;
			doftype[4]=StokesApproximationEnum;
			doftype[5]=StokesApproximationEnum;
		}
		else if (vertices_type[0]==MacAyealStokesApproximationEnum){
			numdofs=6;
			doftype=(int*)xmalloc(numdofs*sizeof(int));
			doftype[0]=MacAyealApproximationEnum;
			doftype[1]=MacAyealApproximationEnum;
			doftype[2]=StokesApproximationEnum;
			doftype[3]=StokesApproximationEnum;
			doftype[4]=StokesApproximationEnum;
			doftype[5]=StokesApproximationEnum;
		}
		else _error_("Approximationtype %i (%s) not implemented yet for DiagnosticHoriz",(int)*vertices_type,EnumToStringx((int)*vertices_type));
	}
	else if (analysis_type==DiagnosticVertAnalysisEnum){
		numdofs=1;
	}
	else if (analysis_type==DiagnosticHutterAnalysisEnum){
		numdofs=2;
	}
	else if (analysis_type==BedSlopeAnalysisEnum || analysis_type==SurfaceSlopeAnalysisEnum){
		numdofs=1;
	}
	else if (analysis_type==ThermalAnalysisEnum){
		numdofs=1;
	}
	else if (analysis_type==EnthalpyAnalysisEnum){
		numdofs=1;
	}
	else if (analysis_type==HydrologyAnalysisEnum){
		numdofs=1;
	}
	else if (analysis_type==MeltingAnalysisEnum){
		numdofs=1;
	}
	else if (analysis_type==PrognosticAnalysisEnum){
		numdofs=1;
	}
	else if (analysis_type==BalancethicknessAnalysisEnum){
		numdofs=1;
	}
	else if (analysis_type==BalancevelocitiesAnalysisEnum){
		numdofs=1;
	}
	else _error_("analysis type: %i (%s) not implemented yet",analysis_type,EnumToStringx(analysis_type));

	/*Now initialize the index*/
	index->Init(numdofs,doftype);

	/*Clean up*/
	 xfree((void**)&doftype);
}
