/*\file UpdateNodePositions.c
 *\brief: update node positions using new geometry defined by new bed and new thickness
 */

#include "./UpdateNodePositions.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	/*diverse: */
	int   noerr=1;

	/*input datasets: */
	DataSet* elements=NULL;
	DataSet* nodes=NULL;
	DataSet* loads=NULL;
	DataSet* materials=NULL;
	Vec      thickness=NULL;
	Vec      bed=NULL;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&UpdateNodePositionsUsage);

	/*Input datasets: */
	FetchData((void**)&elements,NULL,NULL,ELEMENTS,"DataSet",NULL);
	FetchData((void**)&nodes,NULL,NULL,NODES,"DataSet",NULL);
	FetchData((void**)&loads,NULL,NULL,LOADS,"DataSet",NULL);
	FetchData((void**)&materials,NULL,NULL,MATERIALS,"DataSet",NULL);
	FetchData((void**)&thickness,NULL,NULL,THICKNESS,"Vector",NULL);
	FetchData((void**)&bed,NULL,NULL,BED,"DataSet",NULL);
	
	/*!Generate internal degree of freedom numbers: */
	UpdateNodePositionsx(elements,nodes,loads, materials,thickness,bed);

	/*write output datasets: */
	WriteData(NODESOUT,nodes,0,0,"DataSet",NULL);

	/*Free ressources: */
	delete elements;
	delete nodes;
	delete loads;
	delete materials;
	VecFree(&thickness);
	VecFree(&bed);

	/*end module: */
	MODULEEND();
}

void UpdateNodePositionsUsage(void)
{
	_printf_("\n");
	_printf_("   usage: [elements,nodes,loads, materials] = %s(elements,nodes,loads, materials,inputs);\n",__FUNCT__);
	_printf_("\n");
}
