function plot_basaldrag(md,options,width,i,type);

%PLOT_BASALDRAG - plot basal drag
%
%   Usage:
%      plot_basaldrag(md,options,width,i,type);
%
%   See also: PLOTMODEL

%check layer
if md.dim==3,
	if getfieldvalue(options,'layer',1)~=1;
		disp('plot_basaldrag warning: basal drag is displayed in the lower layer')
		changefieldvalue(options,'layer',1);
	end
end

%compute exponents
s=averaging(md,1./md.drag_p,0);
r=averaging(md,md.drag_q./md.drag_p,0);

%compute horizontal velocity
if strcmpi(type,'basal_drag')
	ub=sqrt(md.vx.^2+md.vy.^2)/md.yts;
elseif strcmpi(type,'basal_dragx')
	ub=md.vx/md.yts;
elseif strcmpi(type,'basal_dragy')
	ub=md.vy/md.yts;
end

%compute basal drag
drag=(max(md.g*(md.rho_ice*md.thickness+md.rho_water*md.bed),0)).^r.*(md.drag_coefficient).^2.*ub.^s/1000;

%Figure out if this is a Section plot
if exist(options,'sectionvalue')
	plot_section(md,drag,options,width,i);
	return;
else

	%process data and model
	[x y z elements is2d isplanet]=processmesh(md,[],options);
	[basal_drag datatype]=processdata(md,drag,options);

	%plot basaldrag
	subplot(width,width,i); 
	plot_unit(x,y,z,elements,basal_drag,is2d,isplanet,datatype,options);

	%apply options
	options=addfielddefault(options,'title','Basal drag [kPa]');
	options=addfielddefault(options,'view',2);
	applyoptions(md,basal_drag,options);

end
