/*!\file KMLFileReadx.cpp
 */

#include "./KMLFileReadx.h"
#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"

KML_Object* KMLFileReadx(FILE* fid){

	int     c;
	char*   kstr;
	int     ival;
	bool    bval;
	char*   pstr=NULL;
	double  (*pdval3)[3]=NULL;
	KML_Object*    kobj=NULL;
	KML_Document*  kdoc=NULL;
	KML_File*      kfil=NULL;

	clock_t clock0,clock1;
	time_t  time0, time1;

	clock0=clock();
	time0 =time(NULL);
	_printf_(true,"\nKMLFileReadx Module -- %s",ctime(&time0));

/*  read kml file  */

//	while ((c=getc(fid)) != EOF)
//		_printf_(true,"%c",c);
	while (kstr=KMLFileToken(fid)) {
		if (!strncmp(kstr,"<?xml"      ,5) ||
//			!strncmp(kstr,"<kml"       ,4) ||
			!strncmp(kstr,"<LineString",11) ||
			!strncmp(kstr,"<LinearRing",11))
			KMLFileTagAttrib(NULL,
							 kstr);
		if (!strcmp(kstr,"<extrude>"))
			KMLFileTokenParse(&ival,
							  kstr,
							  fid);
		if (!strcmp(kstr,"<tessellate>"))
			KMLFileTokenParse(&bval,
							  kstr,
							  fid);
		if (!strcmp(kstr,"<altitudeMode>"))
			pstr=KMLFileTokenParse((char *)NULL,NULL,0,
							  kstr,
							  fid);
		if (!strcmp(kstr,"<coordinates>"))
			KMLFileTokenParse(&pdval3,NULL,0,
							  kstr,
							  fid);
		if (!strncmp(kstr,"<LinearRing",11))
			KMLFileTagSkip(kstr,
						   fid);
		if (!strncmp(kstr,"<Document",9)) {
			kdoc=new KML_Document();
			kdoc->Read(fid,kstr);
//			kdoc->DeepEcho();
			kobj=kdoc;
		}
		if (!strncmp(kstr,"<kml",4)) {
			kfil=new KML_File();
			kfil->Read(fid,kstr);
//			kfil->DeepEcho();
			kobj=kfil;
		}

//		_printf_(true,"%s\n",kstr);
		xfree((void**)&kstr);
	}

	clock1=clock();
	time1 =time(NULL);
	_printf_(true,"KMLFileReadx Module -- %f CPU seconds; %f elapsed seconds.\n\n",
			 ((double)(clock1-clock0))/CLOCKS_PER_SEC,difftime(time1,time0));

	return(kobj);
}

