/*! \file KML_Icon.h 
 *  \brief: header file for kml_icon object
 */

#ifndef _KML_ICON_H_
#define _KML_ICON_H_

#define KML_ICON_HREF_LENGTH      800
#define KML_ICON_REFMODE_LENGTH    10
#define KML_ICON_VREFMODE_LENGTH    9
#define KML_ICON_VFORMAT_LENGTH   800
#define KML_ICON_HQUERY_LENGTH    800

/*Headers:*/
/*{{{1*/
#include "../../include/include.h"
#include "../../shared/Exceptions/exceptions.h"
#include "../../EnumDefinitions/EnumDefinitions.h"

#include "./KML_Object.h"
/*}}}*/

class KML_Icon: public KML_Object {

	public:

		char  href[KML_ICON_HREF_LENGTH+1];
		char  refmode[KML_ICON_REFMODE_LENGTH+1];
		float refint;
		char  vrefmode[KML_ICON_VREFMODE_LENGTH+1];
		float vreftime;
		float vboundsc;
		char  vformat[KML_ICON_VFORMAT_LENGTH+1];
		char  hquery[KML_ICON_HQUERY_LENGTH+1];

		/*KML_Icon constructors, destructors {{{1*/
		KML_Icon();
		~KML_Icon();
		/*}}}*/
		/*Object virtual functions definitions:{{{1*/
		void  Echo();
		void  DeepEcho();
		void  DeepEcho(char* indent);
		void  Write(FILE* fid,char* indent);
		void  Read(FILE* fid,char* kstr);
		int   Id(){_error_("Not implemented yet.");};
		int   MyRank(){_error_("Not implemented yet.");};
		void  Marshall(char** pmarshalled_dataset){_error_("Not implemented yet.");};
		int   MarshallSize(){_error_("Not implemented yet.");};
		void  Demarshall(char** pmarshalled_dataset){_error_("Not implemented yet.");};
		int   Enum(){_error_("Not implemented yet.");};
		Object* copy(){_error_("Not implemented yet.");};
		/*}}}*/

};
#endif  /* _KML_ICON_H */

