/*!\file KML_LineStyle.cpp
 * \brief: implementation of the kml_linestyle object
 */

/*Headers:*/
/*{{{1*/
#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "stdio.h"
#include <string.h>
#include "../objects.h"
#include "../../shared/shared.h"
#include "../../Container/Container.h"
#include "../../include/include.h"
/*}}}*/

/*Constructors/destructor/copy*/
/*FUNCTION KML_LineStyle::KML_LineStyle(){{{1*/
KML_LineStyle::KML_LineStyle(){

	width     =1.;

}
/*}}}*/
/*FUNCTION KML_LineStyle::~KML_LineStyle(){{{1*/
KML_LineStyle::~KML_LineStyle(){

	;

}
/*}}}*/

/*Other*/
/*FUNCTION KML_LineStyle::Echo {{{1*/
void  KML_LineStyle::Echo(){

	bool  flag=true;

	_printf_(flag,"KML_LineStyle:\n");
	KML_ColorStyle::Echo();

	_printf_(flag,"         width: %g\n"          ,width);

	return;
}
/*}}}*/

/*FUNCTION KML_LineStyle::DeepEcho {{{1*/
void  KML_LineStyle::DeepEcho(){

	char  indent[81]="";

	KML_LineStyle::DeepEcho(indent);

	return;
}
/*}}}*/

/*FUNCTION KML_LineStyle::DeepEcho {{{1*/
void  KML_LineStyle::DeepEcho(char* indent){

	int   i;
	bool  flag=true;

	_printf_(flag,"%sKML_LineStyle:\n",indent);
	KML_ColorStyle::DeepEcho(indent);

	_printf_(flag,"%s         width: %g\n"          ,indent,width);

	return;
}
/*}}}*/

/*FUNCTION KML_LineStyle::Write {{{1*/
void  KML_LineStyle::Write(FILE* filout,char* indent){

	fprintf(filout,"%s<LineStyle",indent);
	WriteAttrib(filout," ");
	fprintf(filout,">\n");

	KML_ColorStyle::Write(filout,indent);

	fprintf(filout,"%s  <width>%g</width>\n",indent,width);

	fprintf(filout,"%s</LineStyle>\n",indent);

	return;
}
/*}}}*/

/*FUNCTION KML_LineStyle::Read {{{1*/
void  KML_LineStyle::Read(FILE* fid,char* kstr){

	char*        kstri;

/*  get object attributes  */

	KMLFileTagAttrib(this,
					 kstr);

/*  loop over and process fields within opening and closing tags  */

	while (kstri=KMLFileToken(fid)) {
		if      (!strncmp(kstri,"</LineStyle",11)) {
			xfree((void**)&kstri);
			break;
		}
		else if (!strncmp(kstri,"</",2))
			_error_("KML_LineStyle::Read -- Unexpected closing tag %s.\n",kstri);
		else if (strncmp(kstri,"<",1))
			_error_("KML_LineStyle::Read -- Unexpected field \"%s\".\n",kstri);

		else if (!strcmp(kstri,"<width>"))
			KMLFileTokenParse(&width     ,
							  kstri,
							  fid);

		else if (!strncmp(kstri,"<",1))
			KML_ColorStyle::Read(fid,kstri);

		xfree((void**)&kstri);
	}

	return;
}
/*}}}*/

