/*!\file:  PentaRef.h
 * \brief abstract class for handling Penta oriented routines, like nodal functions, 
 * strain rate generation, etc ...
 */ 


#ifndef _PENTAREF_H_
#define _PENTAREF_H_

class PentaRef{
	

	public: 
		int* element_type_list; //P1CG, P1DG, MINI, P2...
		int  element_type;
		
		PentaRef();
		PentaRef(const int nummodels);
		~PentaRef();

		/*Management*/
		void SetElementType(int type,int type_counter);

		/*Numerics*/
		void GetNodalFunctionsP1(double* l1l6, GaussPenta* gauss);
		void GetNodalFunctionsMINI(double* l1l7, GaussPenta* gauss);
		void GetNodalFunctionsP1Derivatives(double* dh1dh6,double* xyz_list, GaussPenta* gauss);
		void GetNodalFunctionsMINIDerivatives(double* dh1dh7,double* xyz_list, GaussPenta* gauss);
		void GetNodalFunctionsP1DerivativesReference(double* dl1dl6,GaussPenta* gauss);
		void GetNodalFunctionsMINIDerivativesReference(double* dl1dl7,GaussPenta* gauss);
		void GetQuadNodalFunctions(double* l1l4,GaussPenta* gauss,int index1,int index2,int index3,int index4);
		void GetQuadJacobianDeterminant(double*  Jdet, double xyz_list[4][3],GaussPenta* gauss);
		void GetJacobian(double* J, double* xyz_list,GaussPenta* gauss);
		void GetJacobianDeterminant(double*  Jdet, double* xyz_list,GaussPenta* gauss);
		void GetTriaJacobianDeterminant(double*  Jdet, double* xyz_list,GaussPenta* gauss);
		void GetSegmentJacobianDeterminant(double*  Jdet, double* xyz_list,GaussPenta* gauss);
		void GetJacobianInvert(double*  Jinv, double* xyz_list,GaussPenta* gauss);
		void GetBMacAyealPattyn(double* B, double* xyz_list, GaussPenta* gauss);
		void GetBMacAyealStokes(double* B, double* xyz_list, GaussPenta* gauss);
		void GetBPattyn(double* B, double* xyz_list, GaussPenta* gauss);
		void GetBStokes(double* B, double* xyz_list, GaussPenta* gauss);
		void GetBprimeMacAyealStokes(double* Bprime, double* xyz_list, GaussPenta* gauss);
		void GetBprimePattyn(double* B, double* xyz_list, GaussPenta* gauss);
		void GetBprimeStokes(double* B_prime, double* xyz_list, GaussPenta* gauss);
		void GetBprimeVert(double* B, double* xyz_list, GaussPenta* gauss);
		void GetBAdvec(double* B_advec, double* xyz_list, GaussPenta* gauss);
		void GetBArtdiff(double* B_artdiff, double* xyz_list, GaussPenta* gauss);
		void GetBConduct(double* B_conduct, double* xyz_list, GaussPenta* gauss);
		void GetBVert(double* B, double* xyz_list, GaussPenta* gauss);
		void GetBprimeAdvec(double* Bprime_advec, double* xyz_list, GaussPenta* gauss);
		void GetL(double* L, GaussPenta* gauss,int numdof);
		void GetLStokes(double* LStokes, GaussPenta* gauss);
		void GetLprimeStokes(double* LprimeStokes, double* xyz_list, GaussPenta* gauss);
		void GetLMacAyealStokes(double* LMacAyealStokes, GaussPenta* gauss);
		void GetLprimeMacAyealStokes(double* LprimeMacAyealStokes, double* xyz_list, GaussPenta* gauss);
		void GetLStokesMacAyeal(double* LStokesMacAyeal, GaussPenta* gauss);
		void GetLprimeStokesMacAyeal(double* LprimeStokesMacAyeal, double* xyz_list, GaussPenta* gauss);
		void GetParameterValue(double* pvalue,double* plist, GaussPenta* gauss);
		void GetParameterValue(double* pvalue,double* plist,GaussTria* gauss){_error_("only PentaGauss are supported");};
		void GetParameterDerivativeValue(double* pvalues, double* plist,double* xyz_list, GaussPenta* gauss);
		void GetParameterDerivativeValue(double* pvalues, double* plist,double* xyz_list, GaussTria* gauss){_error_("only PentaGauss are supported");};

};
#endif
