function displayobservations(md)
%DISPLAYOBSERVATIONS - display observations information
%
%   To avoid clobbering display.m with every field from model md, 
%   we create this routine that displays observations information from model md, 
%   only if requested.
%
%   Usage:
%      displayobservations(md)

disp(sprintf('   Observations:\n'));

fielddisplay(md,'vx_obs','observed velocity x component [m/a]');
fielddisplay(md,'vy_obs','observed velocity y component [m/a]');
fielddisplay(md,'vel_obs','observed velocity magnitude [m/a]');
fielddisplay(md,'vx_obs_raw','raw observedvelocity x component [m/a]');
fielddisplay(md,'vy_obs_raw','raw observed velocity y component [m/a]');
fielddisplay(md,'vel_obs_raw','raw observed magnitude [m/a]');
fielddisplay(md,'surface_mass_balance','surface mass balance [m/a]');
fielddisplay(md,'dhdt','surface dhdt rate [m/a]');
fielddisplay(md,'observed_temperature','observed temperature [K]');
fielddisplay(md,'geothermalflux','geothermal heat flux [W/m^2]');
