/*\file EnumToModelField.cpp:
* \brief: output string associated with enum, that corresponds  to a model field
* for example: ThicknessEnum corresponds to model field thickness
*              DragCoefficientEnum corresponds to model field drag
*/

#include "../shared/shared.h"
#include "../include/include.h"
#include "./EnumDefinitions.h"

char* EnumToModelField(int en){

	switch(en){

		case ThicknessEnum : return "thickness";
		case DragCoefficientEnum : return "drag_coefficient";
		case RheologyBEnum : return "rheology_B";
		case RheologyBbarEnum : return "rheology_B";
		case DhDtEnum : return "dhdt";
		case VxEnum : return "vx";
		case VxObsEnum : return "vx_obs";
		case VyEnum : return "vy";
		case VyObsEnum : return "vy_obs";
		case GroundingLineMigrationEnum : return "gl_migration";
		case AccumulationRateEnum: return "accumulation_rate";
		case BasalMeltingRateEnum: return "basal_melting_rate";
		default : _error_("No model field is associated to enum %s",EnumToStringx(en));
	}
}
