/*
 * UpdateElementsTransient:
 */

#include "../../../Container/Container.h"
#include "../../../toolkits/toolkits.h"
#include "../../../io/io.h"
#include "../../../EnumDefinitions/EnumDefinitions.h"
#include "../../../objects/objects.h"
#include "../../../shared/shared.h"
#include "../../MeshPartitionx/MeshPartitionx.h"
#include "../../../include/include.h"
#include "../ModelProcessorx.h"

void	UpdateElementsTransient(Elements* elements, IoModel* iomodel,FILE* iomodel_handle,int analysis_counter,int analysis_type){

	/*Intermediary*/
	int      i,j;
	int      counter;
	Element *element = NULL;
	char     fetchstring[100]; 
	double   time;

	
	/*download whatever data will persist through forcing processing: */
	IoModelFetchData(&iomodel->elements,NULL,NULL,iomodel_handle,"elements");

	/*Ok, let's go through forcings: */
	/*first, accumulation: */
	if(iomodel->forcing_accumulation_num_time_steps==0)_error_("accumulation forcing not available!");

	iomodel->forcing_numtimesteps=iomodel->forcing_accumulation_num_time_steps;
	IoModelFetchData(&iomodel->timesteps,NULL,NULL,iomodel_handle,"forcing_accumulation_time_steps");

	for(i=0;i<iomodel->forcing_accumulation_num_time_steps;i++){
		time=iomodel->timesteps[i];
		sprintf(&fetchstring[0],"forcing_accumulation_%i",i+1);
		IoModelFetchData(&iomodel->forcing,NULL,NULL,iomodel_handle,fetchstring);



		/*we now have the forcing for the corresponding time step, for all the nodes. Use this 
		 *to write over the existing accumulation input: */

		counter=0;
		for (j=0;j<iomodel->numberofelements;j++){
			if(iomodel->my_elements[j]){
				element=(Element*)elements->GetObjectByOffset(counter);
				element->UpdateForcing(j,iomodel,i,time,AccumulationRateEnum); //we need j to index into elements.
				counter++;

			}
		}



		/*Free ressources:*/
		xfree((void**)&iomodel->forcing);
	}
		

	/*Free ressources:*/
	xfree((void**)&iomodel->forcing);
	xfree((void**)&iomodel->timesteps);
	xfree((void**)&iomodel->elements);

}
