function [analyses,numanalyses,solutioncore]=SolutionConfiguration(solutiontype),
%SOLUTIONCONFIGURATION - return type of analyses, number of analyses and solution_core function
%
%   Usage:
%      [analyses, numanalyses, solutioncore]=SolutionConfiguration(solutiontype);

%get solution_core string
solutioncore=CorePointerFromSolutionEnum(solutiontype);

switch solutiontype,

	case DiagnosticSolutionEnum,
		numanalyses=5;
		analyses=[DiagnosticHorizAnalysisEnum;DiagnosticVertAnalysisEnum;DiagnosticHutterAnalysisEnum;SurfaceSlopeAnalysisEnum;BedSlopeAnalysisEnum];

	case SteadystateSolutionEnum,
		numanalyses=7; 
		analyses=[DiagnosticHorizAnalysisEnum;DiagnosticVertAnalysisEnum;DiagnosticHutterAnalysisEnum;SurfaceSlopeAnalysisEnum;BedSlopeAnalysisEnum;ThermalAnalysisEnum;MeltingAnalysisEnum];

	case ThermalSolutionEnum,
		numanalyses=2; 
		analyses=[ThermalAnalysisEnum;MeltingAnalysisEnum];

	case PrognosticSolutionEnum,
		numanalyses=1; 
		analyses=[PrognosticAnalysisEnum];

	case BalancethicknessSolutionEnum,
		numanalyses=1; 
		analyses=[BalancethicknessAnalysisEnum];

	case BalancevelocitiesSolutionEnum,
		numanalyses=1; 
		analyses=[BalancevelocitiesAnalysisEnum];

	case SurfaceSlopeSolutionEnum,
		numanalyses=1; 
		analyses=[SurfaceSlopeAnalysisEnum];

	case BedSlopeSolutionEnum,
		numanalyses=1; 
		analyses=[BedSlopeAnalysisEnum];

	case Transient2DSolutionEnum,
		numanalyses=6; 
		analyses=[DiagnosticHorizAnalysisEnum;DiagnosticVertAnalysisEnum;DiagnosticHutterAnalysisEnum;SurfaceSlopeAnalysisEnum;BedSlopeAnalysisEnum;PrognosticAnalysisEnum];

	case Transient3DSolutionEnum,
		numanalyses=8; 
		analyses=[DiagnosticHorizAnalysisEnum;DiagnosticVertAnalysisEnum;DiagnosticHutterAnalysisEnum;SurfaceSlopeAnalysisEnum;BedSlopeAnalysisEnum;PrognosticAnalysisEnum;ThermalAnalysisEnum;MeltingAnalysisEnum];

	case FlaimSolutionEnum,
		numanalyses=1; 
		analyses=[FlaimAnalysisEnum];

	case GroundingLineMigration2DSolutionEnum,
		numanalyses=0; 
		analyses=[];

	case HydrologySolutionEnum,
		numanalyses=3; 
		analyses=[BedSlopeAnalysisEnum;SurfaceSlopeAnalysisEnum;HydrologyAnalysisEnum];

	otherwise
		error('%s%s%s',' solution type: ',EnumToString(solutiontype),' not supported yet!');

end
