#!/bin/bash

# issm_webpdf.sh
# convert http://issm/ to issm_web.pdf

# Created by gqwang Thu May 12 13:40:08 PDT 2011

PATH=/usr/bin:/bin:/usr/sbin:/sbin

# 1. Download html
cd /proj/ice/gqwang/
rm -rf issm.jpl.nasa.gov || exit 1
wget -r http://issm.jpl.nasa.gov/

# 2. Convert to pdf
cd issm.jpl.nasa.gov
a=`find . -name "*.html"`
for html in $a; do
   pdf=`echo $html | sed -e '1,1s/\.html/\.pdf/'`
   echo /usr/bin/wkhtmltopdf $html $pdf
done

# 3. Merge into one pdf

mkdir pdf
find . -name "*.pdf" -exec mv {} pdf \;
gs -dBATCH -dNOPAUSE -q -sDEVICE=pdfwrite -sOutputFile=issm_web.pdf pdf/*.pdf
