/*
 * CreateConstraintsThermal.c:
 */

#include "../../../Container/Container.h"
#include "../../../io/io.h"
#include "../../../toolkits/toolkits.h"
#include "../../../EnumDefinitions/EnumDefinitions.h"
#include "../../../objects/objects.h"
#include "../../../shared/shared.h"
#include "../ModelProcessorx.h"

void	CreateConstraintsThermal(Constraints** pconstraints, IoModel* iomodel,FILE* iomodel_handle){

	/*Intermediary*/
	int i;
	int count;
	
	/*Output*/
	Constraints* constraints = NULL;
	Spc*    spc  = NULL;

	/*Recover pointer: */
	constraints=*pconstraints;

	/*Create constraints if they do not exist yet*/
	if(!constraints) constraints = new Constraints(ConstraintsEnum);

	/*return if 2d mesh*/
	if (iomodel->dim==2) goto cleanup_and_return;

	/*Fetch data: */
	IoModelFetchData(&iomodel->spctemperature,NULL,NULL,iomodel_handle,"spctemperature");

	/*Initialize counter*/
	count=0;

	/*Create spcs from x,y,z, as well as the spc values on those spcs: */
	for (i=0;i<iomodel->numberofvertices;i++){
		/*keep only this partition's nodes:*/
		if((iomodel->my_vertices[i])){

			if ((int)iomodel->spctemperature[2*i]){

				constraints->AddObject(new Spc(iomodel->constraintcounter+count+1,iomodel->nodecounter+i+1,1,iomodel->spctemperature[2*i+1],ThermalAnalysisEnum));
				count++;

			}

		} //if((my_nodes[i]==1))
	}

	/*Free data: */
	xfree((void**)&iomodel->spctemperature);

	cleanup_and_return:
	
	/*Assign output pointer: */
	*pconstraints=constraints;
}
