/*
 * UpdateElementsDiagnosticVert:
 */

#include "../../../Container/Container.h"
#include "../../../toolkits/toolkits.h"
#include "../../../io/io.h"
#include "../../../EnumDefinitions/EnumDefinitions.h"
#include "../../../objects/objects.h"
#include "../../../shared/shared.h"
#include "../../MeshPartitionx/MeshPartitionx.h"
#include "../../../include/include.h"
#include "../ModelProcessorx.h"

void	UpdateElementsDiagnosticVert(Elements* elements, IoModel* iomodel,FILE* iomodel_handle,int analysis_counter,int analysis_type){

	/*Intermediary*/
	int i;
	int counter;
	Element* element=NULL;

	/*Now, is the model 3d? otherwise, do nothing: */
	if (iomodel->dim==2)goto cleanup_and_return;

	/*Fetch data needed: */
	IoModelFetchData(&iomodel->elements,NULL,NULL,iomodel_handle,"elements");
	IoModelFetchData(&iomodel->thickness,NULL,NULL,iomodel_handle,"thickness");
	IoModelFetchData(&iomodel->thickness_coeff,NULL,NULL,iomodel_handle,"thickness_coeff");
	IoModelFetchData(&iomodel->surface,NULL,NULL,iomodel_handle,"surface");
	IoModelFetchData(&iomodel->bed,NULL,NULL,iomodel_handle,"bed");
	IoModelFetchData(&iomodel->elementoniceshelf,NULL,NULL,iomodel_handle,"elementoniceshelf");
	IoModelFetchData(&iomodel->elementonbed,NULL,NULL,iomodel_handle,"elementonbed");
	IoModelFetchData(&iomodel->elementonsurface,NULL,NULL,iomodel_handle,"elementonsurface");
	IoModelFetchData(&iomodel->elementonwater,NULL,NULL,iomodel_handle,"elementonwater");
	IoModelFetchData(&iomodel->melting_rate,NULL,NULL,iomodel_handle,"melting_rate");
	IoModelFetchData(&iomodel->accumulation_rate,NULL,NULL,iomodel_handle,"accumulation_rate");
	IoModelFetchData(&iomodel->vx,NULL,NULL,iomodel_handle,"vx");
	IoModelFetchData(&iomodel->vy,NULL,NULL,iomodel_handle,"vy");

	/*Update elements: */
	counter=0;
	for (i=0;i<iomodel->numberofelements;i++){
		if(iomodel->my_elements[i]){
			element=(Element*)elements->GetObjectByOffset(counter);
			element->Update(i,iomodel,analysis_counter,analysis_type); //we need i to index into elements.
			counter++;
		}
	}
	cleanup_and_return:

	/*Free data: */
	xfree((void**)&iomodel->elements);
	xfree((void**)&iomodel->thickness);
	xfree((void**)&iomodel->thickness_coeff);
	xfree((void**)&iomodel->surface);
	xfree((void**)&iomodel->bed);
	xfree((void**)&iomodel->elementoniceshelf);
	xfree((void**)&iomodel->elementonbed);
	xfree((void**)&iomodel->elementonsurface);
	xfree((void**)&iomodel->elementonwater);
	xfree((void**)&iomodel->melting_rate);
	xfree((void**)&iomodel->accumulation_rate);
	xfree((void**)&iomodel->vx);
	xfree((void**)&iomodel->vy);
}
