%PETSCOPTIONS class definition
%
%   Usage:
%      options=petscoptions();

classdef petscoptions
    properties (SetAccess=public) 
		 % {{{1
		 options={NoneAnalysisEnum,mumpsoptions};
		 %used when marshalling
		 %}}}
	 end
	 methods
		 function disp(o) % {{{1
			 %  display the object
			 disp(sprintf('class ''%s'' object ''%s'' = \n',class(o),inputname(1)));
			 %  display the options
			 for i=1:size(o.options,1),
				 analysis=o.options{i,1};
				 ioptions=o.options{i,2};
				 string=petscoptiontostring(ioptions);
				 disp(sprintf('   %s -> ''%s''',EnumToString(analysis),string));
			 end
			 disp(sprintf('\n'));
		 end
		 %}}}
		 function o=addoptions(o,analysis,solveroptions) % {{{1
			 %first, find out if analysis has already been supplied
			 found=0;
			 for i=1:size(o.options,1),
				 inanalysis=o.options{i,1};
				 if inanalysis==analysis,
					 found=1;
					 o.options{i,1}=analysis;
					 o.options{i,2}=solveroptions;
					 break;
				 end
			 end
			 if ~found,
				 o.options{end+1,1}=analysis;
				 o.options{end,2}=solveroptions;
			 end
		 end
		 %}}}
	end
end
