/*! \file CreateLoadsThermal.c:
 */

#include "../../../Container/Container.h"
#include "../../../toolkits/toolkits.h"
#include "../../../io/io.h"
#include "../../../EnumDefinitions/EnumDefinitions.h"
#include "../../../objects/objects.h"
#include "../../../shared/shared.h"
#include "../../../include/include.h"
#include "../ModelProcessorx.h"

void	CreateLoadsThermal(Loads** ploads, IoModel* iomodel,FILE* iomodel_handle){

	/*Intermediary*/
	int i;

	/*DataSet*/
	Loads*    loads    = NULL;
	Pengrid*    pengrid  = NULL;

	/*Recover pointer: */
	loads=*ploads;

	/*Create loads if they do not exist yet*/
	if(!loads) loads = new Loads(LoadsEnum);

	/*return if 2d mesh*/
	if (iomodel->dim==2) _error_("2d meshes not supported yet");

	//create penalties for nodes: no node can have a temperature over the melting point
	IoModelFetchData(&iomodel->spctemperature,NULL,NULL,iomodel_handle,"spctemperature");
	IoModelFetchData(&iomodel->elements,NULL,NULL,iomodel_handle,"elements");
	CreateSingleNodeToElementConnectivity(iomodel);

	for (i=0;i<iomodel->numberofvertices;i++){
	
		/*keep only this partition's nodes:*/
		if((iomodel->my_vertices[i]==1)){

			if (!iomodel->spctemperature[2*i]){ //No penalty applied on spc nodes!

				loads->AddObject(new Pengrid(iomodel->loadcounter+i+1,i,iomodel,ThermalAnalysisEnum));
						
			}
		}
	}
	xfree((void**)&iomodel->spctemperature);
	xfree((void**)&iomodel->elements);
	xfree((void**)&iomodel->singlenodetoelementconnectivity);

	/*Assign output pointer: */
	*ploads=loads;
}
