/*
 * UpdateElementsDiagnosticHutter:
 */

#include "../../../Container/Container.h"
#include "../../../toolkits/toolkits.h"
#include "../../../io/io.h"
#include "../../../EnumDefinitions/EnumDefinitions.h"
#include "../../../objects/objects.h"
#include "../../../shared/shared.h"
#include "../../MeshPartitionx/MeshPartitionx.h"
#include "../../../include/include.h"
#include "../ModelProcessorx.h"

void	UpdateElementsDiagnosticHutter(Elements* elements, IoModel* iomodel,FILE* iomodel_handle,int analysis_counter,int analysis_type){

	/*Intermediary*/
	int i;
	int counter;
	Element* element=NULL;

	/*Now, is the flag hutter on? otherwise, do nothing: */
	if (!iomodel->ishutter)goto cleanup_and_return;

	/*Fetch data needed: */
	IoModelFetchData(&iomodel->nodeonhutter,NULL,NULL,iomodel_handle,"nodeonhutter");
	IoModelFetchData(&iomodel->thickness,NULL,NULL,iomodel_handle,"thickness");
	IoModelFetchData(&iomodel->thickness_coeff,NULL,NULL,iomodel_handle,"thickness_coeff");
	IoModelFetchData(&iomodel->surface,NULL,NULL,iomodel_handle,"surface");
	IoModelFetchData(&iomodel->bed,NULL,NULL,iomodel_handle,"bed");
	IoModelFetchData(&iomodel->nodeonsurface,NULL,NULL,iomodel_handle,"nodeonsurface");
	IoModelFetchData(&iomodel->nodeonbed,NULL,NULL,iomodel_handle,"nodeonbed");
	IoModelFetchData(&iomodel->drag_coefficient,NULL,NULL,iomodel_handle,"drag_coefficient");
	IoModelFetchData(&iomodel->rheology_B,NULL,NULL,iomodel_handle,"rheology_B");
	IoModelFetchData(&iomodel->rheology_n,NULL,NULL,iomodel_handle,"rheology_n");
	IoModelFetchData(&iomodel->elements_type,NULL,NULL,iomodel_handle,"elements_type");
	IoModelFetchData(&iomodel->elementonbed,NULL,NULL,iomodel_handle,"elementonbed");
	IoModelFetchData(&iomodel->elementonsurface,NULL,NULL,iomodel_handle,"elementonsurface");
	IoModelFetchData(&iomodel->elementonwater,NULL,NULL,iomodel_handle,"elementonwater");
	IoModelFetchData(&iomodel->elements,NULL,NULL,iomodel_handle,"elements");

	/*Update elements: */
	counter=0;
	for (i=0;i<iomodel->numberofelements;i++){
		if(iomodel->my_elements[i]){
			element=(Element*)elements->GetObjectByOffset(counter);
			element->Update(i,iomodel,analysis_counter,analysis_type); //we need i to index into elements.
			counter++;
		}
	}
	cleanup_and_return:

	/*Free data: */
	xfree((void**)&iomodel->nodeonhutter);
	xfree((void**)&iomodel->thickness);
	xfree((void**)&iomodel->thickness_coeff);
	xfree((void**)&iomodel->surface);
	xfree((void**)&iomodel->bed);
	xfree((void**)&iomodel->nodeonsurface);
	xfree((void**)&iomodel->nodeonbed);
	xfree((void**)&iomodel->drag_coefficient);
	xfree((void**)&iomodel->rheology_B);
	xfree((void**)&iomodel->rheology_n);
	xfree((void**)&iomodel->elements_type);
	xfree((void**)&iomodel->elementonbed);
	xfree((void**)&iomodel->elementonsurface);
	xfree((void**)&iomodel->elementonwater);
	xfree((void**)&iomodel->elements);
}
