/*
 * CreateNodesDiagnosticHoriz.c:
 */

#include "../../../Container/Container.h"
#include "../../../toolkits/toolkits.h"
#include "../../../io/io.h"
#include "../../../EnumDefinitions/EnumDefinitions.h"
#include "../../../objects/objects.h"
#include "../../../shared/shared.h"
#include "../../MeshPartitionx/MeshPartitionx.h"
#include "../../../include/include.h"
#include "../ModelProcessorx.h"

void	CreateNodesDiagnosticHoriz(Nodes** pnodes, IoModel* iomodel,FILE* iomodel_handle){

	/*Intermediary*/
	int i;
	bool continuous_galerkin=true;

	/*DataSets: */
	Nodes*    nodes = NULL;

	/*Recover pointer: */
	nodes=*pnodes;

	/*First create nodes*/
	if(!nodes) nodes = new Nodes(NodesEnum);
	
	/*Now, is the flag macayaealpattyn on? otherwise, do nothing: */
	if (!iomodel->ismacayealpattyn & !iomodel->isstokes)goto cleanup_and_return;

	/*Continuous Galerkin partition of nodes: */
	NodesPartitioning(&iomodel->my_nodes,iomodel->my_elements,iomodel->my_vertices,iomodel,iomodel_handle,continuous_galerkin);

	/*Create nodes: */
	IoModelFetchData(&iomodel->nodeonbed,NULL,NULL,iomodel_handle,"nodeonbed");
	IoModelFetchData(&iomodel->nodeonsurface,NULL,NULL,iomodel_handle,"nodeonsurface");
	IoModelFetchData(&iomodel->nodeonhutter,NULL,NULL,iomodel_handle,"nodeonhutter");
	IoModelFetchData(&iomodel->nodeonmacayeal,NULL,NULL,iomodel_handle,"nodeonmacayeal");
	IoModelFetchData(&iomodel->nodeonstokes,NULL,NULL,iomodel_handle,"nodeonstokes");
	IoModelFetchData(&iomodel->nodeonicesheet,NULL,NULL,iomodel_handle,"nodeonicesheet");
	IoModelFetchData(&iomodel->nodeoniceshelf,NULL,NULL,iomodel_handle,"nodeoniceshelf");
	IoModelFetchData(&iomodel->nodeonwater,NULL,NULL,iomodel_handle,"nodeonwater");
	IoModelFetchData(&iomodel->vertices_type,NULL,NULL,iomodel_handle,"vertices_type");
	IoModelFetchData(&iomodel->diagnostic_ref,NULL,NULL,iomodel_handle,"diagnostic_ref");
	
	for (i=0;i<iomodel->numberofvertices;i++){

		if(iomodel->my_vertices[i]){
			
			/*Add node to nodes dataset: */
			nodes->AddObject(new Node(iomodel->nodecounter+i+1,i,i+1,i,iomodel,DiagnosticHorizAnalysisEnum));
		}
	}

	/*Clean fetched data: */
	xfree((void**)&iomodel->nodeonbed);
	xfree((void**)&iomodel->nodeonsurface);
	xfree((void**)&iomodel->nodeonhutter);
	xfree((void**)&iomodel->nodeonmacayeal);
	xfree((void**)&iomodel->nodeonstokes);
	xfree((void**)&iomodel->nodeonicesheet);
	xfree((void**)&iomodel->nodeoniceshelf);
	xfree((void**)&iomodel->nodeonwater);
	xfree((void**)&iomodel->vertices_type);	
	xfree((void**)&iomodel->diagnostic_ref);	

	cleanup_and_return:

	/*Assign output pointer: */
	*pnodes=nodes;

}
