/*\file ModelProcessor.h
 * \brief: ModelProcessor module include
 */

#ifndef _MEXMODELPROCESSOR_H_
#define _MEXMODELPROCESSOR_H_

/* local prototypes: */
void ModelProcessorUsage(void);

#include "../../c/modules/modules.h"
#include "../../c/Container/Container.h"
#include "../../c/shared/shared.h"

#undef __FUNCT__ 
#define __FUNCT__  "ModelProcessor"

#undef CLEANUP
#define CLEANUP ModelProcessorLocalCleanup();

#undef ALL
#define ALL 0

/* serial input macros: */
#define INPUTFILE (mxArray*)prhs[0]
#define SOLUTIONTYPE (mxArray*)prhs[1]
#define ANALYSES (mxArray*)prhs[2]

/* serial output macros: */
#define ELEMENTS (mxArray**)&plhs[0]
#define NODES (mxArray**)&plhs[1]
#define VERTICES (mxArray**)&plhs[2]
#define CONSTRAINTS (mxArray**)&plhs[3]
#define LOADS (mxArray**)&plhs[4]
#define MATERIALS (mxArray**)&plhs[5]
#define PARAMETERS (mxArray**)&plhs[6]
		
/* serial arg counts: */
#undef NLHS
#define NLHS  7
#undef NRHS
#define NRHS  3

#endif  /* _MEXMODELPROCESSOR_H */

