function md=structtomodel(md,structmd)
%STRUCTTOMODEL - convert a structure into a model
%
%   This function will take all the fields in structmd and copy them to corresponding
%   fields in the md @model class instance. If the field does not exist in md, it is dropped.
%
%   Usage:
%      md=structtomodel(md,structmd)

structfields=fields(structmd);
for i=1:length(structfields),
	field=structfields(i);field=field{1};
	fieldval=getfield(structmd,field);
	if isfield(struct(md),field),
		md=setfield(md,field,fieldval);
	end
end

%some special treatment for models of previous ISSM versions

%Field name change
if isfield(structmd,'drag'), md.drag_coefficient=structmd.drag; end
if isfield(structmd,'p'), md.drag_p=structmd.p; end
if isfield(structmd,'q'), md.drag_q=structmd.p; end
if isfield(structmd,'B'), md.rheology_B=structmd.B; end
if isfield(structmd,'n'), md.rheology_n=structmd.n; end
if isfield(structmd,'melting'), md.melting_rate=structmd.melting; end
if isfield(structmd,'accumulation'), md.accumulation_rate=structmd.accumulation; end
if isfield(structmd,'numberofgrids'), md.numberofnodes=structmd.numberofgrids; end
if isfield(structmd,'numberofgrids2d'), md.numberofnodes2d=structmd.numberofgrids2d; end
if isfield(structmd,'gridonhutter'), md.nodeonhutter=structmd.gridonhutter; end
if isfield(structmd,'gridonmacayeal'), md.nodeonmacayeal=structmd.gridonmacayeal; end
if isfield(structmd,'gridonpattyn'), md.nodeonpattyn=structmd.gridonpattyn; end
if isfield(structmd,'gridonstokes'), md.nodeonstokes=structmd.gridonstokes; end
if isfield(structmd,'uppergrids'), md.uppernodes=structmd.uppergrids; end
if isfield(structmd,'lowergrids'), md.lowernodes=structmd.lowergrids; end
if isfield(structmd,'gridonbed'), md.nodeonbed=structmd.gridonbed; end
if isfield(structmd,'gridonsurface'), md.nodeonsurface=structmd.gridonsurface; end
if isfield(structmd,'extractedgrids'), md.extractednodes=structmd.extractedgrids; end
if isfield(structmd,'gridoniceshelf'), md.nodeoniceshelf=structmd.gridoniceshelf; end
if isfield(structmd,'gridonicesheet'), md.nodeonicesheet=structmd.gridonicesheet; end
if isfield(structmd,'gridonwater'), md.nodeonwater=structmd.gridonwater; end
if isfield(structmd,'gridonnuna'), md.nodeonnuna=structmd.gridonnuna; end
if isfield(structmd,'gridonboundary'), md.nodeonboundary=structmd.gridonboundary; end

%Field class change
if (isfield(structmd,'type') & ischar(structmd.type)), 
	if strcmpi(structmd.type,'2d'), md.dim=2; end
	if strcmpi(structmd.type,'3d'), md.dim=3; end
end
if isnumeric(md.verbose), md.verbose=verbose; end

%New fields
if ~isfield(structmd,'upperelements');
	md.upperelements=transpose(1:md.numberofelements)+md.numberofelements2d;
	md.upperelements(end-md.numberofelements2d+1:end)=NaN;
end
if ~isfield(structmd,'lowerelements');
	md.lowerelements=transpose(1:md.numberofelements)-md.numberofelements2d;
	md.lowerelements(1:md.numberofelements2d)=NaN;
end
