/*!\file VelocityExtrudex
 * \brief: vertical velocity extrusion
 */

#include "./VelocityExtrudex.h"

#undef __FUNCT__ 
#define __FUNCT__ "VelocityExtrudex"

#include "../shared/shared.h"
#include "../include/macros.h"
#include "../toolkits/toolkits.h"
#include "../EnumDefinitions/EnumDefinitions.h"

void VelocityExtrudex( Vec ug, DataSet* elements,DataSet* nodes, DataSet* loads, DataSet* materials){

	double* ug_serial=NULL;

	/*First, get elements and nodes configured: */
	elements->Configure(elements,loads, nodes, materials);
	nodes->Configure(elements,loads, nodes, materials);

	/*Serialize velcoity: */
	VecToMPISerial(&ug_serial,ug);

	/*Extrude velocity vertically: */
	elements->VelocityExtrude(ug,ug_serial);

	/*Assemble vector: */
	VecAssemblyBegin(ug);
	VecAssemblyEnd(ug);

	/*Free ressources:*/
	xfree((void**)&ug_serial);

}
