function [thickness,surface,bed]=zerothickness_icesheetfront(md,default_value)
%ZEROTHICKNESS_ICESHEETFRONT   zero the thickness, surface and bed at a grounded icefront 
%
% Usage: [thickness,surface,bed]=zerothickness_icesheetfront(md,default)
% 
% See also: parameterize.m

%retrieve thickness, surface and bed
thickness=md.thickness;
bed=md.bed;
surface=md.surface;


%retrieve elements on ice sheet front
segments=md.pressureload;
els=segments(:,3);
pos=find(md.elementonicesheet(els));
segments_icesheet=segments(pos,:);

%retrieve nodes on ice sheet front
node_icesheetfront=intersect(segments_icesheet(:,1),segments_icesheet(:,2));

%modify thickness, surface and bed to be a default value
thickness(node_icesheetfront)=default_value;
bed(node_icesheetfront)=surface(node_icesheetfront)-thickness(node_icesheetfront);

