function md=meshprocessrifts(md,domainoutline)
%MESHPROCESSRIFTS - process mesh when rifts are present
%
%   split rifts inside mesh (rifts are defined by presence of
%   segments inside the domain outline)
%   if domain outline is provided, check for rifts that could touch it, and open them up.
%
%   Usage:
%      md=meshprocessrifts(md,domainoutline)
%
%   Ex: 
%      md=meshprocessrifts(md,'DomainOutline.exp');
%

%some checks on arguments: 
if nargout~=1,
	help meshprocessrifts
	error('meshprocessrifts usage error:');
end

if nargin~=2,
	help meshprocessrifts
	error('meshprocessrifts usage error:');
end

%Call MEX file
[md.elements,md.x,md.y,md.segments,md.segmentmarkers,md.rifts]=TriMeshProcessRifts(md.elements,md.x,md.y,md.segments,md.segmentmarkers);

%Fill in rest of fields:
md.numberofelements=length(md.elements);
md.numberofnodes=length(md.x);
md.z=zeros(md.numberofnodes,1);
md.nodeonboundary=zeros(length(md.x),1); md.nodeonboundary(md.segments(:,1:2))=1;
md.numrifts=length(md.rifts);
md.elements_type=3*ones(md.numberofelements,1);
md.nodeonbed=ones(md.numberofnodes,1);
md.nodeonsurface=ones(md.numberofnodes,1);
md.elementonbed=ones(md.numberofelements,1);
md.elementonsurface=ones(md.numberofelements,1);

%get coordinates of rift tips
for i=1:md.numrifts,
	md.rifts(i).tip1coordinates=[md.x(md.rifts(i).tips(1)) md.y(md.rifts(i).tips(1))];
	md.rifts(i).tip2coordinates=[md.x(md.rifts(i).tips(2)) md.y(md.rifts(i).tips(2))];
end

%In case we have rifts that open up the domain outline, we need to open them: 
flags=ContourToMesh(md.elements,md.x,md.y,domainoutline,'node',0);
found=0;
for i=1:md.numrifts,
	if flags(md.rifts(i).tips(1))==0,
		found=1;
		break;
	end
	if flags(md.rifts(i).tips(2))==0,
		found=1;
		break;
	end
end
if found,
	md=meshprocessoutsiderifts(md,domainoutline);
end

%get elements that are not correctly oriented in the correct direction:
aires=GetAreas(md.elements,md.x,md.y);
pos=find(aires<0);
md.elements(pos,:)=[md.elements(pos,2) md.elements(pos,1) md.elements(pos,3)];
