md=mesh(model,'../Exp/Pig.exp',30000);
md=geography(md,'../Exp/PigShelves.exp','../Exp/PigIslands.exp');
md=parameterize(md,'../Par/Pig.par');
md=extrude(md,3,1);
md=setelementstype(md,'macayeal','all');
md.cluster=none;
md=solve(md,Transient3DSolutionEnum);

%Fields and tolerances to track changes
field_names     ={'Vx1','Vy1','Vz1','Vel1','Pressure1','Bed1','Surface1','Thickness1','Temperature1','MeltingRate1', ...
				      'Vx2','Vy2','Vz2','Vel2','Pressure2','Bed2','Surface2','Thickness2','Temperature2','MeltingRate2'};
field_tolerances={1e-12,1e-12,1e-12,1e-12,1e-12,1e-12,1e-12,1e-12,1e-12,1e-12,1e-12,1e-12,1e-12,1e-12,1e-12,1e-12,1e-12,1e-12,1e-12,1e-12};
field_values={...
	PatchToVec(md.results.Transient3DSolution(1).Vx),...
	PatchToVec(md.results.Transient3DSolution(1).Vy),...
	PatchToVec(md.results.Transient3DSolution(1).Vz),...
	PatchToVec(md.results.Transient3DSolution(1).Vel),...
	PatchToVec(md.results.Transient3DSolution(1).Pressure),...
	PatchToVec(md.results.Transient3DSolution(1).Bed),...
	PatchToVec(md.results.Transient3DSolution(1).Surface),...
	PatchToVec(md.results.Transient3DSolution(1).Thickness),...
	PatchToVec(md.results.Transient3DSolution(1).Temperature),...
	PatchToVec(md.results.Transient3DSolution(1).MeltingRate),...
	PatchToVec(md.results.Transient3DSolution(2).Vx),...
	PatchToVec(md.results.Transient3DSolution(2).Vy),...
	PatchToVec(md.results.Transient3DSolution(2).Vz),...
	PatchToVec(md.results.Transient3DSolution(2).Vel),...
	PatchToVec(md.results.Transient3DSolution(2).Pressure),...
	PatchToVec(md.results.Transient3DSolution(2).Bed),...
	PatchToVec(md.results.Transient3DSolution(2).Surface),...
	PatchToVec(md.results.Transient3DSolution(2).Thickness),...
	PatchToVec(md.results.Transient3DSolution(2).Temperature),...
	PatchToVec(md.results.Transient3DSolution(2).MeltingRate),...
	};
