md=mesh(model,'../Exp/Pig.exp',20000);
md=geography(md,'../Exp/PigShelves.exp','../Exp/PigIslands.exp');
md=parameterize(md,'../Par/Pig.par');
md=setelementstype(md,'macayeal','all');
md.cluster=none;
md=solve(md,Transient2DSolutionEnum);

%Fields and tolerances to track changes
field_names     ={'Vx1','Vy1','Vel1','Pressure1','Bed1','Surface1','Thickness1','Vx2','Vy2','Vel2','Pressure2','Bed2','Surface2','Thickness2'};
field_tolerances={1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13};
field_values={...
	PatchToVec(md.results.Transient2DSolution(1).Vx),...
	PatchToVec(md.results.Transient2DSolution(1).Vy),...
	PatchToVec(md.results.Transient2DSolution(1).Vel),...
	PatchToVec(md.results.Transient2DSolution(1).Pressure),...
	PatchToVec(md.results.Transient2DSolution(1).Bed),...
	PatchToVec(md.results.Transient2DSolution(1).Surface),...
	PatchToVec(md.results.Transient2DSolution(1).Thickness),...
	PatchToVec(md.results.Transient2DSolution(2).Vx),...
	PatchToVec(md.results.Transient2DSolution(2).Vy),...
	PatchToVec(md.results.Transient2DSolution(2).Vel),...
	PatchToVec(md.results.Transient2DSolution(2).Pressure),...
	PatchToVec(md.results.Transient2DSolution(2).Bed),...
	PatchToVec(md.results.Transient2DSolution(2).Surface),...
	PatchToVec(md.results.Transient2DSolution(2).Thickness),...
	};
