md=mesh(model,'../Exp/Square.exp',180000);
md=geography(md,'all','');
md=parameterize(md,'../Par/SquareShelf.par');
md=extrude(md,3,1);
md=setelementstype(md,'macayeal','all');
md=SetParallel(md,3);
md=solve(md,ThermalSolutionEnum);

%Fields and tolerances to track changes
field_names     ={'Temperature1','MeltingRate1','Temperature2','MeltingRate2','Temperature3','MeltingRate3'};
field_tolerances={1e-13,1e-13,1e-13,1e-13,1e-13,1e-13};
field_values={...
	PatchToVec(md.results.ThermalSolution(1).Temperature),...
	PatchToVec(md.results.ThermalSolution(1).MeltingRate),...
	PatchToVec(md.results.ThermalSolution(2).Temperature),...
	PatchToVec(md.results.ThermalSolution(2).MeltingRate),...
	PatchToVec(md.results.ThermalSolution(3).Temperature),...
	PatchToVec(md.results.ThermalSolution(3).MeltingRate),...
	};
