md=mesh(model,'../Exp/Square.exp',180000);
md=geography(md,'all','');
md=parameterize(md,'../Par/SquareShelf.par');
md=extrude(md,3,1);
md=setelementstype(md,'macayeal','all');
md.dt=0;
md.cluster=none;
md=solve(md,ThermalSolutionEnum);

%Fields and tolerances to track changes
field_names     ={'Temperature','MeltingRate'};
field_tolerances={1e-13,1e-13};
field_values={...
	PatchToVec(md.results.ThermalSolution.Temperature),...
	PatchToVec(md.results.ThermalSolution.MeltingRate),...
	};
